<?php
/**
 * @package    plg_staticcache
 *
 * @author     christophf <your@email.com>
 * @copyright  A copyright
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       http://your.url.com
 */

use Joomla\CMS\Application\CMSApplication;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Database\DatabaseDriver;

defined('_JEXEC') or die;

/**
 * Plg_staticcache plugin.
 *
 * @package  plg_staticcache
 * @since    1.0
 */
class plgSystemStaticcache extends CMSPlugin
{
	/**
	 * Application object
	 *
	 * @var    CMSApplication
	 * @since  1.0
	 */
	protected $app;

	/**
	 * Database object
	 *
	 * @var    DatabaseDriver
	 * @since  1.0
	 */
	protected $db;

	/**
	 * onAfterRender.
	 *
	 * @return  void.
	 *
	 * @since   1.0
	 */
	public function onAfterRender()
	{
		$url = (isset($_SERVER['HTTPS']) ? "https" : "http").'://'.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];

		// If admin don't cache
		if (strpos($url, 'administrator') !== false) {
			return;
		}

		// if there a messages don't cache them
		if (is_array($messages = $this->app->getMessageQueue())) {
			if (count($messages) > 0) {
				return;
			}
			// echo '<pre style="display:none;">'.print_r($messages, 1).'</pre>';
		}

		$urlParts = parse_url($url);
		$uri = $urlParts['path'] !== '/' ? $urlParts['path'] : '/index';

		// if non SEF Url we skip caching.
		if (strpos($uri, 'index.php') !== false) return;

		$uri = str_replace(['.html', '.php'], '', $uri).'.html';
		$file = JPATH_BASE . "/cache/static$uri";
		// echo "<pre>".print_r([$urlParts, $file], 1).'</pre>';
		if (!is_dir(dirname($file))) {
			mkdir(dirname($file), 0777, true);
		}
		$content = $this->app->getBody();

		// Don't Cache broken Pages.
		if (strpos($content, 'Error')) return;

		file_put_contents($file, $this->app->getBody());
	}

	public function onAfterExecute($event)
	{
		print_r($event);
	}
}
