<?php
/**
 * @package    iframe_box
 *
 * @author     christophf <your@email.com>
 * @copyright  A copyright
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       http://your.url.com
 */

defined('_JEXEC') or die;

use Joomla\CMS\Application\CMSApplication;
use Joomla\CMS\Plugin\CMSPlugin;

/**
 * Iframe_box plugin.
 *
 * @package   iframe_box
 * @since     1.0.0
 */
class plgSystemIframe_box extends CMSPlugin
{
	/**
	 * Application object
	 *
	 * @var    CMSApplication
	 * @since  1.0.0
	 */
	protected $app;

	protected $version;

	/**
	 * Affects constructor behavior. If true, language files will be loaded automatically.
	 *
	 * @var    boolean
	 * @since  1.0.0
	 */
	protected $autoloadLanguage = true;

	/**
	 * onAfterDispatch.
	 *
	 * @return  void
	 *
	 * @since   1.0
	 */
	public function onAfterDispatch()
	{
        if (!$this->checkGates()) return;

        $this->doc = $this->app->getDocument();

        $this->doc->addScript(JUri::base(true) . '/media/iframe_box/js/iframeBox.js', [
            'version' => $this->getVersion(),
        ]);

        if ($this->params->get('loadCss', null)) {
            $this->doc->addStyleSheet(JUri::base(true) . '/media/iframe_box/css/iframeBox.css', [
                'version' => $this->getVersion(),
            ]);
        }

        $options = json_encode([
            'linkClass' => $this->params->get('linkClass', 'iframe-link'),
            'boxClass' => $this->params->get('boxClass', 'iframe-box'),
        ]);

        $this->doc->addScriptDeclaration("document.addEventListener('DOMContentLoaded', function() { new IframeBox($options); });");
	}

    protected function getVersion(): string
    {
        if ($this->version) return $this->version;

        $xml = simplexml_load_file(JPATH_PLUGINS . "/iframe_box/iframe_box.xml");

        return $this->version = (string) $xml->version;
	}

    protected function checkGates(): bool
    {
        if ($this->app->isClient('administrator')) return false;

        if ($this->isEditPage()) return false;

        return true;
    }

    protected function isEditPage(): bool
    {
        $input = $this->app->input;

        $option = $input->get('option');

        // always return false for these components
        if (in_array($option, ['com_rsevents', 'com_rseventspro']))
        {
            return false;
        }

        $task = $input->get('task');

        if (strpos($task, '.') !== false)
        {
            $task = explode('.', $task);
            $task = array_pop($task);
        }

        $view = $input->get('view');

        if (strpos($view, '.') !== false)
        {
            $view = explode('.', $view);
            $view = array_pop($view);
        }

        return
            (
                in_array($option, ['com_contentsubmit', 'com_cckjseblod'])
                || ($option == 'com_comprofiler' && in_array($task, ['', 'userdetails']))
                || in_array($task, ['edit', 'form', 'submission'])
                || in_array($view, ['edit', 'form'])
                || in_array($input->get('do'), ['edit', 'form'])
                || in_array($input->get('layout'), ['edit', 'form', 'write'])
            );
    }
}
