<?php


namespace ckMonster\Handlers;

use ckMonster\Dom\ExtendedDOMElement;
use ckMonster\Dom\Finder;
use ckMonster\HandlerInterface;
use Joomla\CMS\Application\CMSApplication;

class GoogleTranslate extends BaseHandler implements HandlerInterface
{
    protected $finder;

    public function __construct(\DOMDocument $document, CMSApplication $app)
    {
        parent::__construct($document, $app);

        $this->finder = new Finder($this->dom);
    }

    public function getElements(): \DOMNodeList
    {
        return $this->finder->queryAll("//script[contains(@src, \"translate.google.com/translate_a/element.js\")]");
    }

    public static function hasElements(string $content): bool
    {
        return strpos($content, 'translate.google.com/translate_a/element.js') !== false;
    }

    protected function handleElement(ExtendedDOMElement $element)
    {
        $element->setAttribute('data-consent', 'google-translate');
        $element->setAttribute('type', 'text/plain');
        $element->setAttribute('data-type', 'text/javascript');
        $element->setAttribute('data-src', $element->getAttribute('src'));
        $element->removeAttribute('src');
    }
}
