<?php


namespace ckMonster\Handlers;

use ckMonster\Dom\ExtendedDOMElement;
use ckMonster\Dom\Finder;
use ckMonster\HandlerInterface;
use Joomla\CMS\Application\CMSApplication;

class GoogleMaps extends BaseHandler implements HandlerInterface
{
	protected $finder;

	public function __construct(\DOMDocument $document, CMSApplication $app)
	{
		parent::__construct($document, $app);

		$this->finder = new Finder($this->dom);
	}

	public function getElements(): \DOMNodeList
	{
		return $this->finder->queryAll([
			"//script[contains(@src, \"maps.google.com\")]",
			"//script[contains(@src, \"maps.googleapis.com\")]",
		]);
	}

	public static function hasElements(string $content): bool
	{
		return strpos($content, 'maps.google.com') !== false ||
			strpos($content, 'maps.googleapis.com') !== false;
	}

	protected function handleElement(ExtendedDOMElement $element)
	{
		if (strpos($element->getAttribute('src'), 'key') === false) {
			$element->parentNode->removeChild($element);
			return;
		}

		$element->setAttribute('data-consent', 'google-maps');
		$element->setAttribute('type', 'text/plain');
		$element->setAttribute('data-type', 'text/javascript');
		$element->setAttribute('data-src', $element->getAttribute('src') . '&callback=mapsConsent');
		$element->removeAttribute('src');
	}

    public function run($content = null)
    {
        parent::run($content);

        // Add Callbacks for JS to hook in
        $head = $this->finder->query('head');

	    $scriptNode = $this->dom->createElement('script');
	    $scriptNode->nodeValue = '
          const googleMapsCallbacks = [];
          function mapsConsent() {
            "use strict";
            
            googleMapsCallbacks.forEach(function(cb) { cb(); });
          }';

	    $head->insertBefore($scriptNode, $head->firstElementChild);
    }
}
