<?php


namespace ckMonster\Handlers\ReCaptchaExtensions;


use ckMonster\Dom\ExtendedDOMElement;
use ckMonster\Dom\Finder;
use ckMonster\HandlerInterface;
use ckMonster\Handlers\BaseHandler;
use Joomla\CMS\Application\CMSApplication;

class RsForm extends BaseHandler implements HandlerInterface
{
    protected $finder;

    public function __construct(\DOMDocument $document, CMSApplication $app)
    {
        parent::__construct($document, $app);

        $this->finder = new Finder($this->dom);
    }

    public function getElements(): \DOMNodeList
    {
        return $this->finder->queryAll("//*[self::fieldset or self::div][contains(@id, \"rsform_\")]/ancestor::form");
    }

    protected function handleElement(ExtendedDOMElement $element)
    {
        $recaptcha = $this->finder->query(".//div[contains(@id, \"g-recaptcha-\")]", $element);
        $recaptcha->nodeValue = \JText::_( 'PLG_COOKIECONSENT_BLOCKED_RECAPTCHA' );

        $sendBtn = $this->finder->query(".//*[self::button or self::input][@type=\"submit\"]", $element);
        $sendBtn->setAttribute('disabled', true);
    }

    static function hasElements(string $content): bool
    {
        return strpos($content, 'rsform') !== false;
    }

    public function run($content = null)
    {
        parent::run($content);

        $head = $this->finder->query('head');

        // Add script to remove disabled attribute
        $scriptNode = $this->dom->createElement('script');
        $scriptNode->setAttribute('type', 'text/javascript');
        $scriptNode->nodeValue = '
        RSFormProReCAPTCHAv2.loaders.forEach(function(loader) {
            recaptchaCallbacks.push(loader);
        });
        
        RSFormProReCAPTCHAv2.loaders = [];
        
        const selectors = [
            ".rsform > form input[type=submit]",
            ".rsform > form button[type=submit]",
            ".rsform-block input[type=submit]",
            ".rsform-block button[type=submit]",
            ".rsform-submit-button",
        ];
        
        recaptchaCallbacks.push(function() {
            [].slice.call(document.querySelectorAll(selectors.join(", "))).forEach(function(el) {el.removeAttribute("disabled");});
        })';

        $head->appendChild($scriptNode);
    }
}
