<?php


namespace ckMonster\Handlers\ReCaptchaExtensions;


use ckMonster\Dom\ExtendedDOMElement;
use ckMonster\Dom\Finder;
use ckMonster\HandlerInterface;
use ckMonster\Handlers\BaseHandler;
use Joomla\CMS\Application\CMSApplication;

class Acymailing extends BaseHandler implements HandlerInterface
{
    protected $finder;

    public function __construct(\DOMDocument $document, CMSApplication $app)
    {
        parent::__construct($document, $app);

        $this->finder = new Finder($this->dom);
    }

    public function getElements(): \DOMNodeList
    {
        return $this->finder->queryAll("//div[@id=\"acymailing-captcha\"]/ancestor::form");
    }

    protected function handleElement(ExtendedDOMElement $element)
    {
        $className = $element->getAttribute('class');
        $element->setAttribute('class', "$className js-blocked-acy");

        $recaptcha = $this->finder->query("//div[contains(@class, \"g-recaptcha\")]", $element);
        $recaptcha->nodeValue = \JText::_( 'PLG_COOKIECONSENT_BLOCKED_RECAPTCHA' );

        $sendBtn = $this->finder->query("//*[self::button or self::input][@type=\"submit\"]", $element);
        $sendBtn->setAttribute('disabled', true);
    }

    static function hasElements(string $content): bool
    {
        return strpos($content, 'acymailing-captcha') !== false;
    }

    public function run($content = null)
    {
        parent::run($content);

        $head = $this->finder->query('head');

        // Add script to remove disabled attribute
        $scriptNode = $this->dom->createElement('script');
        $scriptNode->setAttribute('type', 'text/javascript');
        $scriptNode->nodeValue = '        
        recaptchaCallbacks.push(function() {
            [].slice.call(document.querySelectorAll(".js-blocked-acy *[type=submit]")).forEach(function(el) {el.removeAttribute("disabled");});
        })';

        $head->appendChild($scriptNode);
    }
}
