<?php

namespace ckMonster\Handlers\IframeExtensions;


class Vimeo extends BaseVendor implements IframeInterface
{
	public const needle = 'vimeo';
	protected $vendor = 'vimeo';

	public function getThumbnail($width): ?string
	{
		$OEmbed = $this->getOembed($width);

		return $OEmbed->thumbnail_url;
	}

	public function getVideoId()
	{
		return substr($this->getUrlParts('path'), 1);
	}

	protected function getOembed(int $width): ?object
	{
		$parameters = [
			'width' => $width,
		];

		$parameters['url'] = "https://vimeo.com/{$this->getVideoId()}";
		$str = $this->cURL('https://vimeo.com/api/oembed.json', $parameters);

		return ($str) ? json_decode($str) : null;
	}
}
