<?php


namespace ckMonster\Handlers;


use ckMonster\Dom\ExtendedDOMElement;
use ckMonster\Dom\Finder;
use ckMonster\HandlerInterface;
use ckMonster\Handlers\BaseHandler;
use Joomla\CMS\Application\CMSApplication;

class JuxInstagram extends BaseHandler implements HandlerInterface
{
    protected $siteKeys = [];
    protected $finder;

    public function __construct(\DOMDocument $document, CMSApplication $app)
    {
        parent::__construct($document, $app);

        $this->finder = new Finder($this->dom);
    }

    public function getElements(): \DOMNodeList
    {
        return $this->finder->queryAll(".jux_easy_instagram_feed");
    }

    protected function handleElement(ExtendedDOMElement $element)
    {
        $iframe = $this->dom->createElement('iframe');
        $iframe->setAttribute('class', 'jux_easy_instagram_feed_blocked');
        $iframe->setAttribute('data-consent', 'instagram');

        $element->appendChild($iframe);
    }

    static function hasElements(string $content): bool
    {
        return strpos($content, 'jux_easy_instagram_feed') !== false;
    }

    public function run($content = null)
    {
        parent::run($content);

        $head = $this->finder->query('head');

        // Add script to remove disabled attribute
        $scriptNode = $this->dom->createElement('script');
        $scriptNode->setAttribute('data-consent', 'instagram');
        $scriptNode->setAttribute('type', 'text/plain');
        $scriptNode->setAttribute('data-type', 'text/javascript');
        $scriptNode->nodeValue = 'Load_Ajax_Data();';

        $head->appendChild($scriptNode);

        // Add styles to hide loading indicator
        $styles = $this->dom->createElement('style');
        $styles->nodeValue = 'iframe.jux_easy_instagram_feed_blocked {
            width: 100%;
            min-height: 200px;
            position: relative;
            z-index: 9999;
            border: none;
        }';

        $head->appendChild($styles);
    }

    public static function modScripts(array &$scripts): void
    {
        foreach ($scripts as &$script) {
            if (strpos($script, 'jux_easy_instagram_feed') !== false) {
                $script = str_ireplace('function Load_Ajax_Data()', 'window.Load_Ajax_Data = function Load_Ajax_Data()', $script);
                $script = str_ireplace('Load_Ajax_Data();', '/** REMOVED BY ckMnstr **/', $script);
            }
        }
    }
}
