<?php

namespace ckMonster\Handlers\ReCaptchaExtensions;

use ckMonster\Dom\ExtendedDOMElement;
use ckMonster\Dom\Finder;
use ckMonster\HandlerInterface;
use ckMonster\Handlers\BaseHandler;
use Joomla\CMS\Application\CMSApplication;

class HikaShop extends BaseHandler implements HandlerInterface
{
	protected $finder;

	public function __construct(\DOMDocument $document, CMSApplication $app)
	{
		parent::__construct($document, $app);

		$this->finder = new Finder($this->dom);
	}

	public function getElements(): \DOMNodeList
	{
		return $this->finder->queryAll('.hika-recaptcha');
	}

	protected function handleElement(ExtendedDOMElement $element)
	{
		$scriptElement = $element->nextElementSibling();

        $scriptElement->setAttribute('type', 'text/plain');
        $scriptElement->setAttribute('data-consent', 'recaptcha');
        $scriptElement->setAttribute('data-type', 'text/javascript');
	}

	static function hasElements(string $content): bool
	{
		return strpos($content, 'hika-recaptcha') !== false;
	}

    public static function modScripts(array &$scripts): void
    {
        foreach ($scripts as &$script) {
            if (strpos($script, 'onloadCallbackHKRecaptcha ') !== false) {
                $script = preg_replace('/document\.addEventListener\("DOMContentLoaded", (.*?})\);/s', '($1)();', $script);
            }
        }
    }
}
