<?php


namespace ckMonster\Handlers\ReCaptchaExtensions;


use ckMonster\Dom\ExtendedDOMElement;
use ckMonster\Dom\Finder;
use ckMonster\HandlerInterface;
use ckMonster\Handlers\BaseHandler;
use Joomla\CMS\Application\CMSApplication;

class PWebContactForm extends BaseHandler implements HandlerInterface
{
    protected $siteKeys = [];
    protected $finder;

    public function __construct(\DOMDocument $document, CMSApplication $app)
    {
        parent::__construct($document, $app);

        $this->finder = new Finder($this->dom);
    }

    public function getElements(): \DOMNodeList
    {
        return $this->finder->queryAll("//div[contains(@id, \"pwebcontact\")][contains(@id, \"captcha\")]");

    }

    protected function handleElement(ExtendedDOMElement $element)
    {
        $id = $element->getAttribute('id');
        $key = (int) filter_var($id, FILTER_SANITIZE_NUMBER_INT);
        $className = $element->getAttribute('class');
        $element->setAttribute('id', "$id-ckMonster");
        $element->setAttribute('class', "$className g-recaptcha");
        $element->setAttribute('data-sitekey', $this->siteKeys[$key]);
        $element->nodeValue = \JText::_( 'PLG_COOKIECONSENT_BLOCKED_RECAPTCHA' );

        $sendBtn = $this->finder->query("//button[contains(@id, \"pwebcontact${key}_send\")]");
        $sendBtn->setAttribute('disabled', true);
    }

    static function hasElements(string $content): bool
    {
        return strpos($content, 'pwebcontact') !== false;
    }

    public function run($content = null)
    {
        // Find all jQuery Scripts for pWebContact
        preg_match_all('/"pwebcontact(\d+)_captcha.*?sitekey:"([^"]*)"/', $content, $matches, PREG_SET_ORDER);
        $this->siteKeys = array_reduce($matches, function($carry, $match) {
            // Match[1] = ID, Match[2] Sitekey
            $carry[$match[1]] = $match[2];
            return $carry;
        }, []);

        parent::run($content);

        $head = $this->finder->query('head');

        // Add script to remove disabled attribute
        $scriptNode = $this->dom->createElement('script');
        $scriptNode->setAttribute('data-consent', 'recaptcha');
        $scriptNode->setAttribute('type', 'text/plain');
        $scriptNode->setAttribute('data-type', 'text/javascript');
        $scriptNode->nodeValue = '[].slice.call(document.querySelectorAll(\'.pweb-field button[id*=_send]\')).forEach(function(el) {el.removeAttribute(\'disabled\');})';

        $head->appendChild($scriptNode);
    }

    public static function modScripts(array &$scripts): void
    {
        foreach ($scripts as &$script) {
            $script = preg_replace('/jQuery\(document\)\.ready\(function\(\$\){\$\(window\).*grecaptchaId.*?\);/', '', $script);
        }
    }
}
