<?php


namespace ckMonster\Handlers;

use ckMonster\Dom\ExtendedDOMElement;
use ckMonster\HandlerInterface;

use ckMonster\Handlers\IframeExtensions\{
	IframeInterface,
	Facebook,
	GoogleMaps,
	Softgarden,
	Technikboerse,
	Vimeo,
	Youtube,
};

class IframeHandler extends BaseHandler implements HandlerInterface
{
    public function getElements(): \DOMNodeList
    {
        return $this->dom->getElementsByTagName('iframe');
    }

    public static function hasElements(string $content): bool
    {
        return strpos($content, '<iframe') !== false;
    }

    public function handleElement(ExtendedDOMElement $iframe): void
    {
        $src = $iframe->getAttribute('src');

        if ($vendor = $this->getVendor($src)) {
	        $width = (int) $iframe->getAttribute('width') ?: 1280;

	        $iframe->setAttribute('data-src', $vendor->getUrl());
	        $iframe->setAttribute('data-consent', $vendor->getVendorName());
	        $iframe->mergeAttribute('class', 'privacy-iframe');

	        if ($thumb = $this->cachedCallback($src, function () use ($vendor, $width) {
		        return $vendor->getProxyThumb($width);
	        })) {
	        	$iframe->mergeAttribute('style', 'background-image: url(' . $thumb . ')');
	        }

	        $iframe->removeAttribute('src');
        }
    }

	protected function getVendor(string $src): ?IframeInterface
	{
		$vendors = [
			Youtube::class,
			Vimeo::class,
			Facebook::class,
			Technikboerse::class,
			GoogleMaps::class,
			Softgarden::class,
		];

		/** @var IframeInterface $vendor */
		foreach ($vendors as $vendor)
		{
			if ($vendor::check($src)) {
				return new $vendor($src);
			}
		}
		return null;
    }
}
