<?php


namespace ckMonster\Handlers;


use ckMonster\Dom\ExtendedDOMElement;
use ckMonster\Dom\Finder;
use Joomla\CMS\Application\CMSApplication;

class FacebookFeedPro extends BaseHandler
{
	protected $finder;

	public function __construct(\DOMDocument $document, CMSApplication $app)
	{
		parent::__construct($document, $app);

		$this->finder = new Finder($this->dom);
	}

	public static function hasElements(string $content): bool
	{
		return strpos($content, 'facebookfeedpro-feed') !== false;
	}

	protected function getElements(): \DOMNodeList
	{
		return $this->finder->queryAll('.facebookfeedpro-feed');
	}

	protected function handleElement(ExtendedDOMElement $element)
	{
		$element->setAttribute('data-consent', 'facebook');
		$element->setAttribute('class', 'facebookfeedpro-feed--replaced');

        self::setInnerHTML($element, '<div class="cookie-notice cookie-notice--facebookfeedpro">' . \JText::_( 'PLG_COOKIECONSENT_BLOCKED_FACEBOOK' ) . '</div>');
	}

	public function run($content = null)
	{
		parent::run($content);

		$head = $this->finder->query('head');

		// Add script to remove disabled attribute
		$scriptNode = $this->dom->createElement('script');
		$scriptNode->setAttribute('type', 'text/plain');
		$scriptNode->setAttribute('data-type', 'text/javascript');
		$scriptNode->setAttribute('data-consent', 'facebook');
		$scriptNode->nodeValue = '
		a4jRequire(["ffp_app", "ffp_feed", "jquery"], function(App, Feed, $){
			var configNode = $(\'#ffp-frontend-cfg\');
	        if(configNode.length==0){
	            App.showMessage(\'No FFP config\', \'error\');
	        }
	        var config = JSON.parse(configNode.html());
	        if(!config || typeof config.feedConfig==\'undefined\'){
	            App.showMessage(\'Wrong FFP config\', \'error\');
	        }

	        Feed.setTranslation(config.i18n);
	        
	        $(".facebookfeedpro-feed--replaced").each(function(){
	            var node = $(this);
	            var _feed = Feed.create($.extend({},config.feedConfig,{"id":node.attr("data-id")}));
	            _feed.renderTo(node);
	        });
	    });';

		$head->appendChild($scriptNode);
	}
}
