<?php

namespace ckMonster\Handlers\IframeExtensions;


class Youtube extends BaseVendor implements IframeInterface
{
	public const needle = 'youtu';
	protected $vendor = 'youtube';

	public function getUrl(): string
	{
		return preg_replace('/youtube\./', 'youtube-nocookie.', $this->url);
	}

	public function getThumbnail($width): ?string
	{
		$videoId = $this->getVideoId();

		$maxresDefault = "https://i.ytimg.com/vi/{$videoId}/maxresdefault.jpg";
		$hqDefault = "https://i.ytimg.com/vi/{$videoId}/hqdefault.jpg";

		if ($this->getHttpResponseCode($maxresDefault) !== 404) {
			return $maxresDefault;
		}

		return $hqDefault;
	}

	public function getVideoId()
	{
		return substr($this->getUrlParts('path'), 7);
	}
}
