<?php

namespace ckMonster\Handlers\IframeExtensions;


class Facebook extends BaseVendor implements IframeInterface
{
	public const needle = 'facebook';
	protected $vendor = 'facebook';

	public function getThumbnail($width): ?string
	{
		$OEmbed = $this->getOembed($width);

		return $OEmbed->thumbnail_url;
	}

	public function getVideoId()
	{
		if ($id = $this->getQuery('v')) {
			return $id;
		} else if (preg_match('/(?:videos\/|v=)([\d]*)/', $this->getUrl(), $matches)) {
			return $matches[1];
		}

		return null;
	}
}
