<?php

namespace ckMonster\Handlers\GoogleMapsExtensions;

use ckMonster\Dom\ExtendedDOMElement;
use ckMonster\Dom\Finder;
use ckMonster\HandlerInterface;
use ckMonster\Handlers\BaseHandler;
use Joomla\CMS\Application\CMSApplication;

class SobiPro extends BaseHandler implements HandlerInterface
{
	protected $finder;

	public function __construct(\DOMDocument $document, CMSApplication $app)
	{
		parent::__construct($document, $app);

		$this->finder = new Finder($this->dom);
	}

	public function getElements(): \DOMNodeList
	{
		return $this->finder->queryAll([".ctrl-geomap", ".ctrl-geomap-search"]);
	}

	public static function hasElements(string $content): bool
	{
		return strpos($content, 'ctrl-geomap', strpos($content, '</head>')) !== false;
	}

	protected function handleElement(ExtendedDOMElement $element)
	{
		$input = $this->finder->query('input', $element);

		if ($input) {
			$input->setAttribute('disabled', true);
			$input->setAttribute('data-placeholder', $input->getAttribute('placeholder'));
			$input->setAttribute('placeholder', \JText::_( 'PLG_COOKIECONSENT_BLOCKED' ));
		}

		$classList = array_map(function($className) {
			return (in_array($className, ['ctrl-geomap', 'ctrl-geomap-search'])) ? "$className-ckmnstr" : $className;
		}, explode(' ', $element->getAttribute('class')));

		$element->setAttribute('class', implode(' ', $classList));
	}

	public function run($content = null)
	{
		parent::run($content);

		$head = $this->finder->query('head');

		// Add script to remove disabled attribute
		$scriptNode = $this->dom->createElement('script');
		$scriptNode->setAttribute('type', 'text/javascript');

		$scriptNode->nodeValue = '
          googleMapsCallbacks.push(function() {
            SobiPro.jQuery(\'.ctrl-geomap-search-ckmnstr\').each(function(i,e) {
              const mapCanvas = e.querySelector(\'.ctrl-geomap-ckmnstr\');
              mapCanvas.classList.replace(\'ctrl-geomap-ckmnstr\', \'ctrl-geomap\');

              const input = e.querySelector(\'input\');
              input.removeAttribute(\'disabled\');
              input.setAttribute(\'placeholder\', input.getAttribute(\'data-placeholder\'));

              SobiPro.jQuery(e).SobiProGeoMapGoogleSearch()
            });
            
            SobiPro.jQuery(\'.ctrl-geomap-ckmnstr\').each(function(i,e) {
              if (SobiPro.jQuery.fn.SobiProGeoMapEdit) {
                SobiPro.jQuery(e).SobiProGeoMapEdit();
              } else if (SobiPro.jQuery.fn.SobiProGeoMapField) {
                SobiPro.jQuery(e).SobiProGeoMapField();
              }
            });
          })';

		$head->appendChild($scriptNode);
	}
}
