<?php

namespace ckMonster\Handlers\GoogleMapsExtensions;

use ckMonster\Dom\ExtendedDOMElement;
use ckMonster\Dom\Finder;
use ckMonster\HandlerInterface;
use ckMonster\Handlers\BaseHandler;
use Joomla\CMS\Application\CMSApplication;

class RsDirectory extends BaseHandler implements HandlerInterface
{
	protected $finder;

	public function __construct(\DOMDocument $document, CMSApplication $app)
	{
		parent::__construct($document, $app);

		$this->finder = new Finder($this->dom);
	}

	public function getElements(): \DOMNodeList
	{
        $formEl = $this->finder->query('.rsdir-radius-search-form');

		return $this->finder->queryAll([
			"//input[@name='location']",
			"//button[@type='submit']",
		], $formEl);
	}

	public static function hasElements(string $content): bool
	{

        return (strpos($content, 'rsdir-radius-search', strpos($content, '</head>')) !== false ||
                strpos($content, 'com_rsdirectory/js/jquery.radius-search.js') !== false) && strpos($content, 'rsdir-map') !== false;
	}

	protected function handleElement(ExtendedDOMElement $element)
	{
		if ($element->nodeName === 'input') {
			$element->setAttribute('placeholder', \JText::_( 'PLG_COOKIECONSENT_BLOCKED_MAPS' ));
			$element->setAttribute('disabled', true);
		} else {
            $element->setAttribute('disabled', true);
            $element->setAttribute('alt', \JText::_( 'PLG_COOKIECONSENT_BLOCKED_MAPS' ));
		}


		$element->setAttribute('data-blocked-consent', 'google-maps');
	}

	public function run($content = null)
	{
		parent::run($content);

        $mapEl = $this->finder->query('.rsdir-map');

        $iframeEl =$this->dom->createElement('iframe');
        $iframeEl->setAttribute('data-consent', 'google-maps');

        $mapEl->appendChild($iframeEl);

		$head = $this->finder->query('head');

		// Add script to remove disabled attribute
		$scriptNode = $this->dom->createElement('script');
		$scriptNode->setAttribute('type', 'text/javascript');

		$scriptNode->nodeValue = 'googleMapsCallbacks.push(function() {
			document.querySelectorAll("[data-blocked-consent=google-maps]").forEach(function(el) {
				el.removeAttribute("data-blocked-consent");
				el.removeAttribute("disabled");
				el.removeAttribute("placeholder");
			});
		});';

		$head->appendChild($scriptNode);
	}

	public static function modScripts(array &$scripts): void
	{
		foreach ($scripts as &$script) {
			$script = preg_replace('/.*(jQuery\(\s*document\.getElementById\("rsdir-map-canvas"\)\s*\).*?\}\);).*/ms', "googleMapsCallbacks.push(function(){\n\t$1\n});", $script);
		}
	}
}
