<?php

namespace ckMonster\Handlers\GoogleMapsExtensions;

use ckMonster\Dom\ExtendedDOMElement;
use ckMonster\Dom\Finder;
use ckMonster\HandlerInterface;
use ckMonster\Handlers\BaseHandler;
use Joomla\CMS\Application\CMSApplication;

class JEvents extends BaseHandler implements HandlerInterface
{
	protected $finder;

	public function __construct(\DOMDocument $document, CMSApplication $app)
	{
		parent::__construct($document, $app);

		$this->finder = new Finder($this->dom);
	}

	public function getElements(): \DOMNodeList
	{
		return $this->finder->queryAll([
			"//div[contains(@id, \"gmapMulti\")]",
			"//div[@id='jevents']//div[contains(@id, \"gmap\")]",
			"//form[@id='jeventspost']//input[@id='googleaddress']",
		]);
	}

	public static function hasElements(string $content): bool
	{
		return (strpos($content, 'gmap', strpos($content, '</head>')) !== false ||
			strpos($content, 'geolocation.js') !== false) && strpos($content, 'jevents') !== false;
	}

	protected function handleElement(ExtendedDOMElement $element)
	{
		if ($element->nodeName === 'input') {
			$element->setAttribute('placeholder', \JText::_( 'PLG_COOKIECONSENT_BLOCKED_MAPS' ));
			$element->setAttribute('disabled', true);
		} else {
			self::setInnerHTML($element, '<div>' . \JText::_( 'PLG_COOKIECONSENT_BLOCKED_MAPS' ) . '</div>');
		}


		$element->setAttribute('data-blocked-consent', 'google-maps');
	}

	public function run($content = null)
	{
		parent::run($content);

		$head = $this->finder->query('head');

		// Add script to remove disabled attribute
		$scriptNode = $this->dom->createElement('script');
		$scriptNode->setAttribute('type', 'text/javascript');

		$scriptNode->nodeValue = 'googleMapsCallbacks.push(function(){
			if (typeof myMapload !== "undefined") myMapload();
			document.querySelectorAll("[data-blocked-consent=google-maps]").forEach(function(el) {
				el.removeAttribute("data-blocked-consent");
				el.removeAttribute("disabled");
				el.removeAttribute("placeholder");
			});
		});';

		if ($this->finder->query('#googleaddress')) {
			$scriptNode->nodeValue .= 'googleMapsCallbacks.push(function() {
			try {
				myGeocoder = new google.maps.Geocoder();
				// set the form onsubmit event
				var myform = jQuery("#jeventspost");
				if (myform.length > 0) {
					var $googleaddress = jQuery("#googleaddress");
			
					$googleaddress.on(\'change input\', function(ev) {
						clearlonlat();
					});
			
					myform.on("submit", function (event) {
						var $gvelem = jQuery("#geosearch_fv");
						// if auto geolocating then we have the address and longitude/latitude already
						if ($gvelem.length > 0 &&& $gvelem.val()!=""){
							return true;
						}
			
						var $googleaddress = jQuery("#googleaddress");
						if ($googleaddress.length > 0) {
							googleaddress = $googleaddress.val();
						}
						// force submit to wait for the address to be checked
						if (googleaddress &&& googleaddress.length > 0) {
							var eventObj = new DOMEvent(event);
							try {
								eventObj.stop();
							}
							catch (e) {
								eventObj.stopImmediatePropagation();
							}
							findAddressGeo(eventObj, 1);
						}
					});
				}
			} catch (e) {}
			});';
		}

		preg_match_all('/"(myMapload(?:Multi\d+)?)\(\)"/', $content, $matches);
		foreach($matches[1] as $match) {
			$scriptNode->nodeValue .= "googleMapsCallbacks.push($match)";
		}

		$head->appendChild($scriptNode);
	}

	public static function modScripts(array &$scripts): void
	{
		foreach ($scripts as &$script) {
			$script = preg_replace('/"(myMapload(?:Multi\d+)?)\(\)"/', 'function(){console.log(\'Stubbed \\1\')}', $script);
		}
	}
}
