<?php

namespace ckMonster\Dom;

use DOMElement;
use DOMNodeList;

class Finder
{
    protected $dom;
    protected $finder;

    public function __construct(\DOMDocument $dom)
    {
        $this->dom = $dom;
        $this->finder = new \DomXPath($dom);
    }

    public function queryAll($selector, ?DOMElement $parent = null): ?DOMNodeList
    {
        // if selector is array combine both xpath selectors
        if (is_array($selector)) {
            $query = implode(' | ', array_map([$this, 'buildSelector'], $selector));
        } else {
            $query = self::buildSelector($selector);
        }

        // if we have a valid query return here
        if ($query) {
            return $this->finder->query($query, $parent);
        }

        // getElementsByTagName expect a string
        if (is_string($selector)) {
            return ($parent) ? $parent->getElementsByTagName($selector) : $this->dom->getElementsByTagName($selector);
        }
        return null;
    }

    public function query($selector, ?DOMElement $parent = null): ?DOMElement
    {
        return $this->queryAll($selector, $parent)->item(0);
    }

    /**
     * Builds a xpath query based on the selector.
     * Only supports simple class and id selectors or a xpath query.
     *
     * @param string $selector
     *
     * @return string|null
     * @since 5.8.0
     */
    private static function buildSelector(string $selector): ?string
    {
        if (strpos($selector, '#') === 0) {
            $selector = substr($selector, 1);
            return "//*[contains(concat(' ', normalize-space(@id), ' '), ' $selector ')]";
        } else if (strpos($selector, './/') === 0) {
	        return $selector;
        } else if (strpos($selector, '.') === 0) {
            $selector = substr($selector, 1);
            return "//*[contains(concat(' ', normalize-space(@class), ' '), ' $selector ')]";
        } else if (strpos($selector, '[') === 0) {
            return "//*$selector";
        } else if (strpos($selector, '/') === 0) {
            return $selector;
        }
        return null;
    }
}
