<?php


namespace ckMonster\Dom;


class ExtendedDOMElement extends \DOMElement
{
	public function mergeAttribute($attr, $value)
	{
		if (is_array($value)) {
			$value = implode(' ', $value);
		}
		$attrs = array_filter([trim($this->getAttribute($attr)), $value]);

		return $this->setAttribute($attr, implode(' ', $attrs));
	}

	public function nextElementSibling(): self
	{
		$element = $this;
		while ($element = $element->nextSibling) {
			if ($element instanceof self) {
				break;
			}
		}

		return $element;
	}
}
