<?php


namespace ckMonster\Handlers\IframeExtensions;


abstract class BaseVendor implements IframeInterface
{
	const needle = '';

	protected $url;
	protected $vendor;

	public function __construct(string $src)
	{
		$this->url = $src;
	}

	public static function check(string $src): bool
	{
		return (strpos($src, static::needle) !== false);
	}

	public function getUrl(): string
	{
		return $this->url;
	}

	public function getThumbnail($width): ?string
	{
		return null;
	}

	public function getVendorName(): string
	{
		return $this->vendor;
	}

	protected function getQuery(?string $key = null)
	{
		$parts = $this->getUrlParts($key);

		if (isset($parts['query'])) {
			parse_str($parts['query'], $query);
		} else {
			$query = null;
		}

		return ($key) ? $query[$key] : $query;
	}

	protected function getUrlParts(?string $key)
	{
		$parts = parse_url($this->getUrl());
		return ($key) ? $parts[$key] : $parts;
	}

	protected function getOembed(int $width): ?object
	{
		return null;
	}

	protected function cURL(string $url, array $parameters = []): string
	{
		$query = http_build_query($parameters);

		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => "$url?$query",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 3,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "GET",
			CURLOPT_POSTFIELDS => "",
			CURLOPT_HTTPHEADER => array(
				"Accept: application/json",
				"Referer: " . \JUri::root(),
			),
		));

		$response = curl_exec($curl);
		$err = curl_error($curl);
		$errNo = curl_errno($curl);

		curl_close($curl);

		if ($err) {
			throw new Exception($err, $errNo);
		}
		return $response;
	}
}
