<?php

namespace ckMonster\Handlers\IframeExtensions;


class Youtube extends BaseVendor implements IframeInterface
{
	public const needle = 'youtu';
	protected $vendor = 'youtube';

	public function getUrl(): string
	{
		return preg_replace('/youtube\./', 'youtube-nocookie.', $this->url);
	}

	public function getThumbnail($width): ?string
	{
		return "https://i.ytimg.com/vi/{$this->getVideoId()}/maxresdefault.jpg";
	}

	public function getVideoId()
	{
		return substr($this->getUrlParts('path'), 7);
	}
}
