<?php


namespace ckMonster\Handlers;


use Joomla\CMS\Application\CMSApplication;
use Joomla\CMS\Cache\Cache;

abstract class BaseHandler
{
    protected $dom;
    protected $app;
    protected $cache;

    abstract protected function getElements(): \DOMNodeList;
    abstract protected function handleElement(\DOMElement $element);

    public function __construct(\DOMDocument $document, CMSApplication $app)
    {
        $this->dom = $document;
        $this->app = $app;

        $this->cache = new Cache([
            'defaultgroup' => 'plg_cookieconsent',
            'caching' => true,
            'lifetime' => 3600,
        ]);
    }

    public static function handle(\DOMDocument $document, CMSApplication $app, $content = null)
    {
        $handler = new static($document, $app);

        $handler->run($content);
    }

    protected function cachedCallback(string $id, callable $callback)
    {
        $cached = $this->cache->get($id);

        if (empty($cached)) {
            $value = $callback();
            $this->cache->store(serialize($value), $id);
            return $value;
        }

        return unserialize($cached);
    }

    public function handleElements()
    {
        $elements = $this->getElements();

        foreach ($elements as $element) {
            $this->handleElement($element);
        }
    }

    public function run($content = null)
    {
        $this->handleElements();
    }
}
