<?php

namespace ckMonster\Dom;

use DOMElement;
use DOMNodeList;

class Finder
{
    protected $dom;
    protected $finder;

    public function __construct(\DOMDocument $dom)
    {
        $this->dom = $dom;
        $this->finder = new \DomXPath($dom);
    }

    public function queryAll(string $selector, ?DOMElement $parent = null): DOMNodeList
    {
        if (strpos($selector, '#') === 0) {
            $selector = substr($selector, 1);
            return $this->finder->query("//*[contains(concat(' ', normalize-space(@id), ' '), ' $selector ')]", $parent);
        } else if (strpos($selector, '.') === 0) {
            $selector = substr($selector, 1);
            return $this->finder->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' $selector ')]", $parent);
        } else if (strpos($selector, '[') === 0) {
            return $this->finder->query("//*$selector", $parent);
        } else if (strpos($selector, '/') === 0) {
            return $this->finder->query("$selector", $parent);
        }
        return ($parent) ? $parent->getElementsByTagName($selector) : $this->dom->getElementsByTagName($selector);
    }

    public function query(string $selector, ?DOMElement $parent = null): ?DOMElement
    {
        return $this->queryAll($selector, $parent)->item(0);
    }
}
