<?php


namespace ckMonster\Handlers;

use ckMonster\Dom\Finder;
use ckMonster\HandlerInterface;
use Joomla\CMS\Application\CMSApplication;

class SobiGoogle extends BaseHandler implements HandlerInterface
{
    protected $finder;

    public function __construct(\DOMDocument $document, CMSApplication $app)
    {
        parent::__construct($document, $app);

        $this->finder = new Finder($this->dom);
    }

    public function getElements(): \DOMNodeList
    {
        return $this->finder->queryAll(".ctrl-geomap-search");
    }

    public static function hasElements(string $content): bool
    {
        return strpos($content, 'ctrl-geomap-search') !== false;
    }

    protected function handleElement(\DOMElement $element)
    {
        $input = $this->finder->query('input', $element);

        $input->setAttribute('disabled', true);
        $input->setAttribute('data-placeholder', $input->getAttribute('placeholder'));
        $input->setAttribute('placeholder', \JText::_( 'PLG_COOKIECONSENT_BLOCKED' ));

        $element->setAttribute('class', str_replace('ctrl-geomap-search', 'ctrl-geomap-search-ckmnstr', $element->getAttribute('class')));
    }

    public function run()
    {
        parent::run();

        // Handle Maps script
        $maps = $this->finder->query("[contains(normalize-space(@src), 'maps.google.com')]");

        $maps->setAttribute('data-consent', 'google-maps');
        $maps->setAttribute('type', 'text/plain');
        $maps->setAttribute('data-type', 'text/javascript');
        $maps->setAttribute('data-src', $maps->getAttribute('src') . '&callback=mapsConsent');
        $maps->removeAttribute('src');


        // Add Callbacks for JS to hook in
        $head = $this->finder->query('head');

        $scriptNode = $this->dom->createElement('script');
        $scriptNode->nodeValue = '
          function mapsConsent() {
            SobiPro.jQuery(\'.ctrl-geomap-search-ckmnstr\').each(function(i,e) {
              const input = e.querySelector(\'input\');
              input.removeAttribute(\'disabled\');
              input.setAttribute(\'placeholder\', input.getAttribute(\'data-placeholder\'));
              
              SobiPro.jQuery(e).SobiProGeoMapGoogleSearch()
            });
          }';

        $head->appendChild($scriptNode);
    }
}
