<?php


namespace ckMonster\Handlers;

use ckMonster\Dom\Finder;
use ckMonster\HandlerInterface;
use Joomla\CMS\Application\CMSApplication;

class ReCaptcha extends BaseHandler implements HandlerInterface
{
    protected $finder;

    public function __construct(\DOMDocument $document, CMSApplication $app)
    {
        parent::__construct($document, $app);

        $this->finder = new Finder($this->dom);
    }

    public function getElements(): \DOMNodeList
    {
        return $this->finder->queryAll("//script[contains(@src, \"www.google.com/recaptcha/api.js\")]");
    }

    public static function hasElements(string $content): bool
    {
        return strpos($content, 'www.google.com/recaptcha/api.js') !== false;
    }

    protected function handleElement(\DOMElement $element)
    {
        $element->parentNode->removeChild($element);
    }

    public function run($content = null)
    {
        parent::run($content);

        // Add Callbacks for JS to hook in
        $head = $this->finder->query('head');

        $scriptNode = $this->dom->createElement('script');
        $scriptNode->setAttribute('data-consent', 'recaptcha');
        $scriptNode->setAttribute('type', 'text/plain');
        $scriptNode->setAttribute('data-type', 'text/javascript');
        $scriptNode->setAttribute('data-src', '//www.google.com/recaptcha/api.js?onload=initReCaptcha&render=explicit');
        $head->appendChild($scriptNode);

        $scriptNode = $this->dom->createElement('script');
        $scriptNode->nodeValue = '
          const recaptchaCallbacks = [];
          function initReCaptcha() {
            "use strict";
            for (var t, e, a = document.getElementsByClassName("g-recaptcha"), c = ["sitekey", "theme", "type", "size", "tabindex", "callback", "expired-callback"], i = {}, r = 0, s = a.length; r < s; r++) {
                if ((t = a[r]).dataset) i = t.dataset;
                else
                    for (var d = 0; d < c.length; d++) e = "data-" + c[d], t.hasAttribute(e) && (i[c[d]] = t.getAttribute(e));
                t.setAttribute("data-recaptcha-widget-id", grecaptcha.render(t, i))
            }
            
            recaptchaCallbacks.forEach(function(cb) { cb(); });
          }';

        $head->appendChild($scriptNode);
    }
}
