<?php

namespace ckMonster\Handlers\GoogleMapsExtensions;

use ckMonster\Dom\Finder;
use ckMonster\HandlerInterface;
use ckMonster\Handlers\BaseHandler;
use Joomla\CMS\Application\CMSApplication;

class JEvents extends BaseHandler implements HandlerInterface
{
	protected $finder;

	public function __construct(\DOMDocument $document, CMSApplication $app)
	{
		parent::__construct($document, $app);

		$this->finder = new Finder($this->dom);
	}

	public function getElements(): \DOMNodeList
	{
		return $this->finder->queryAll([
			"//div[contains(@id, \"gmapMulti\")]",
			"//div[@id='jevents']//div[contains(@id, \"gmap\")]",
		]);
	}

	public static function hasElements(string $content): bool
	{
		return strpos($content, 'gmap', strpos($content, '</head>')) !== false;
	}

	protected function handleElement(\DOMElement $element)
	{
		self::setInnerHTML($element, '<div>' . \JText::_( 'PLG_COOKIECONSENT_BLOCKED_MAPS' ) . '</div>');

		$element->setAttribute('data-blocked-consent', 'google-maps');
	}

	public function run($content = null)
	{
		parent::run($content);

		$head = $this->finder->query('head');

		// Add script to remove disabled attribute
		$scriptNode = $this->dom->createElement('script');
		$scriptNode->setAttribute('type', 'text/javascript');

		$scriptNode->nodeValue = 'googleMapsCallbacks.push(function(){
			document.querySelectorAll("[data-blocked-consent=google-maps]").forEach(function(el) {
				el.removeAttribute("data-blocked-consent");
			});
		});';

		preg_match_all('/"(myMapload(?:Multi\d+)?)\(\)"/', $content, $matches);
		foreach($matches[1] as $match) {
			$scriptNode->nodeValue .= "googleMapsCallbacks.push($match)";
		}

		$head->appendChild($scriptNode);
	}

	public static function modScripts(array &$scripts): void
	{
		foreach ($scripts as &$script) {
			$script = preg_replace('/"(myMapload(?:Multi\d+)?)\(\)"/', 'function(){console.log(\'Stubbed \\1\')}', $script);
		}
	}
}
