<?php
/**
 * @package    softgarden
 *
 * @author     christophf <your@email.com>
 * @copyright  A copyright
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       http://your.url.com
 */

defined('_JEXEC') or die;

use Joomla\CMS\Helper\ModuleHelper;

$grouped = $params->get('grouped', false);
$direction = $params->get('direction', 'DESC');

/** @var Softgarden $softgarden */
$items = $softgarden->getData($grouped, $direction);
?>

<table class="sg-table">
  <thead class="sg-table__head">
    <tr>
      <td class="sg-job__title">Stellenangebot</td>
      <td class="sg-job__audiences">Zielgruppe</td>
      <td class="sg-job__categories">Jobkategorie</td>
      <td class="sg-job__city">Standort</td>
    </tr>
  </thead>
  <tbody>
    <?php if (empty($items)): ?>
      <tr>
        <td colspan="4" style="text-align: center; padding: 2rem;">Leider gibt es derzeit keine treffenden Stellenangebote.</td>
      </tr>
    <?php else: ?>
      <?php if ($grouped): ?>
      <?php endif; ?>
      <?php foreach ($items as $groupKey => $item): ?>
        <?php if ($grouped && $groupKey): ?>
          <tr class="sg-table__job sg-group"><td colspan="4"><?= $groupKey ?></td></tr>
        <?php endif; ?>
        <?php
            $jobs = ($grouped) ? $item : [$item];
        ?>
        <?php foreach ($jobs as $job): ?>
          <tr class="sg-table__job sg-job">
            <td class="sg-job__title">
              <a href="<?= $job->job_ad_url ?>" target="_blank"><?= $job->externalPostingName ?></a>
            </td>
            <td class="sg-job__audiences"><?= join(', ', $job->audiences) ?></td>
            <td class="sg-job__categories"><?= join(', ', $job->jobCategories) ?></td>
            <td class="sg-job__city"><?= $job->geo_city ?></td>
          </tr>
        <?php endforeach; ?>
      <?php endforeach; ?>
    <?php endif; ?>
  </tbody>
</table>
