<?php


namespace pxShare\targets;


use Joomla\CMS\Application\CMSApplication;

abstract class Target
{
    public $icon;

    /**
     * @var CMSApplication
     */
    protected $app;

    protected $url;
    protected $has_message = false;
    protected $style = [];
    protected $target = '_blank';

    public function __construct(CMSApplication $app)
    {
        $this->app = $app;
    }

    public static function build(string $url, CMSApplication $app)
    {
        return (new static($app))->run($url);
    }

    protected function run(string $url): string
    {
        return $this->getLink($url);
    }

    protected function getClassName(): string
    {
        return (new \ReflectionClass($this))->getShortName();
    }

    protected function getCssClass(): string
    {
        return 'share-target share-target--' . strtolower($this->getClassName());
    }

    protected function getTranslationKey(): string
    {
        return 'MOD_SHARE_TARGET_' . strtoupper($this->getClassName());
    }

    protected function getText(string $url): string
    {
        if($this->has_message) {
            if (substr_count($this->url, "%s") >= 2 ) {
                return $this->shareLink($url, \JTEXT::_($this->getTranslationKey()));
            }
            return $this->shareLink(\JText::sprintf($this->getTranslationKey(), $url));
        }

        return $this->shareLink($url);
    }

    protected function shareLink(string $url, ?string $msg = null): string
    {
        return sprintf($this->url, urlencode($url), urlencode($msg));
    }

    protected function getStyle(): string
    {
        return implode(';', $this->style);
    }

    protected function getIcon(): string
    {
        return file_get_contents(JPATH_BASE . '/media/mod_share/images/' . $this->icon);
    }

    protected function getTitle(): string
    {
        return \JTEXT::_($this->getTranslationKey() . '_TITLE');
    }

    public function getLink(string $url): string
    {
        return "<a style='{$this->getStyle()}' title='{$this->getTitle()}' target='{$this->target}' class='{$this->getCssClass()}' href=\"{$this->getText($url)}\">{$this->getIcon()}</a>";
    }
}
