<?php


namespace pxShare\targets;


class Mail extends Target
{
    public $icon = 'mail.svg';
    protected $target = '_self';

    protected function getText(string $url): string
    {
        $subject = \JTEXT::sprintf($this->getTranslationKey() . '_SUBJECT');
        $body = \JTEXT::sprintf($this->getTranslationKey() . '_BODY', $url);

        return "mailto:?subject=$subject&body=$body";
    }
}
