<?php


namespace pxShare;


use Joomla\CMS\Application\CMSApplication;

class Main
{
    public static function run(CMSApplication $app)
    {
        $app->getDocument()->addStyleSheet(\JUri::root(true) . '/media/mod_share/css/style.css');
        (new static)->render($app);
    }

    private function render(CMSApplication $app): void
    {
        echo '<div class="px-share">' . $this->buildShareTargets(\JUri::current(), $app) . '</div>';
    }

    private function buildShareTargets(string $url, CMSApplication $app): string
    {
        return implode('', array_map(function ($target) use ($url, $app) {
            return $target::build($url, $app);
        }, [
            \pxShare\targets\Facebook::class,
            \pxShare\targets\FacebookMessenger::class,
            \pxShare\targets\Twitter::class,
            \pxShare\targets\Whatsapp::class,
            \pxShare\targets\Mail::class,
            \pxShare\targets\Clipboard::class,
            \pxShare\targets\ShareDialog::class,
        ]));
    }
}
