<?php


namespace pxShare\targets;


class ShareDialog extends Target
{
    public $icon = 'share.svg';
    protected $target = '_self';

    protected function getText(string $url): string
    {
        return "javascript:share_dialog('$url')";
    }

    protected function run(string $url): string
    {
        $this->app->getDocument()->addScriptDeclaration('
        
        document.addEventListener("DOMContentLoaded", function() {        
            if (!navigator.share) {
                [].slice.call(document.querySelectorAll(".share-target--sharedialog")).forEach(function(el) {
                    el.remove();
                });
            }
        });
        
        function share_dialog(url) {
            navigator.share({
              title: document.title,
              url,
            });
        }');

        return parent::run($url); // TODO: Change the autogenerated stub
    }
}
