<?php


namespace pxShare\targets;


class Clipboard extends Target
{
    public $icon = 'clipboard.svg';
    protected $target = '_self';

    protected function getText(string $url): string
    {
        return "javascript:share_clipboard('$url')";
    }

    protected function run(string $url): string
    {
        $this->app->getDocument()->addScriptDeclaration('function share_clipboard(url) {
            navigator.clipboard.writeText(url);
        }');

        return parent::run($url); // TODO: Change the autogenerated stub
    }
}
