<?php

use Joomla\CMS\Cache\Cache;
use Joomla\CMS\Helper\ModuleHelper;

if (!class_exists('MenusHelper'))
{
    JLoader::register('MenusHelper', JPATH_ADMINISTRATOR . '/components/com_menus/helpers/menus.php');
}

class Sdnet
{
    protected $sdnet_link;
    public $target = '_blank';
    protected $version;
    protected Cache $cache;
    protected $doc;

    public function __construct(\Joomla\Registry\Registry $params)
    {
        $this->doc = JFactory::getDocument();

        $this->sdnet_link = $params->get('sdnet_link');
        $this->target = $params->get('target', '_blank');

        $this->cache = new Cache([
            'defaultgroup' => 'mod_sdnet',
            'caching'      => true,
            'lifetime'     => 3600,
        ]);

        $this->appendMedia();
    }

    protected function cacheKey(): string
    {
        return md5(date("d.m.Y") . $this->sdnet_link . $this->version);
    }

    protected function getMeetings(): array
    {
        return $this->cachedCallback($this->cacheKey(), function () {
            return $this->_fetch("{$this->sdnet_link}/webservice/portal/getTermine?dateFrom=" . date("d.m.Y"));
        });
    }

    public function getData(): array
    {
        return $this->getMeetings();
    }

    protected function cachedCallback(string $id, callable $callback)
    {
        $cached = $this->cache->get($id);

        if (empty($cached))
        {
            $value = $callback();
            $this->cache->store(serialize($value), $id);

            return $value;
        }

        return unserialize($cached);
    }


    protected function _fetch(string $url)
    {
        $curl = curl_init();

        curl_setopt_array($curl, [
            CURLOPT_URL            => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING       => "",
            CURLOPT_MAXREDIRS      => 10,
            CURLOPT_TIMEOUT        => 30,
            CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST  => "GET",
            CURLOPT_POSTFIELDS     => "",
            CURLOPT_HTTPHEADER     => [
//				"Authorization: Basic YTVmMmE5YmEtMWRkNi00OGQ1LTg0MmEtYmZlNDI5NjRmMmVkOg==",
                "Content-Type: application/json",
            ],
        ]);

        $response = curl_exec($curl);
        $err      = curl_error($curl);

        curl_close($curl);

        if ($err)
        {
            throw new Exception($err);
        } else
        {
            return json_decode($response);
        }
    }

    protected function appendMedia()
    {
        $this->doc->addStyleSheet(JUri::base(true) . '/media/mod_sdnet/css/sdnet.css', [
            'version' => $this->hashedVersion(),
        ]);
    }

    protected function hashedVersion(): string
    {
        return substr(sha1($this->getVersion()), 0, 8);
    }

    protected function getVersion(): string
    {
        if ($this->version) return $this->version;

        $xml = simplexml_load_file(__DIR__ . "/mod_sdnet.xml");

        return $this->version = (string) $xml->version;
    }
}
