<?php
/**
 * Created by PhpStorm.
 * User: christophf
 * Date: 10.07.2018
 * Time: 17:53
 */

namespace pixelCMS;

use JCache;
use JFactory;
use Joomla\CMS\Helper\ModuleHelper;

class Slider {
    protected $cache;

    public function __construct()
    {

        $this->cache = new JCache([]);
        $this->cache->setCaching(true);
    }

    private function getSlider() {
        $curl = curl_init();
        $api_token = JFactory::getApplication()->get('pixel_cms_token');
        $parameters = [
            'api_token'=> $api_token,
        ];

        $query = http_build_query($parameters);

        $url = "https://cms.pixel-kraft.de/api/v1/sliders?$query";

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 5,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_POSTFIELDS => "",
            CURLOPT_HTTPHEADER => array(
                "accept: application/json"
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);

        return $response;
    }

    public function getCache()
    {
        $slider = $this->cache->get('slider', 'pixelcms_slider');

        if (empty($slider)) {
            $slider = $this->getSlider();
            $this->cache->store($slider, 'slider', 'pixelcms_slider');
        }

        return json_decode($slider);
    }

    public function display($params)
    {
        $slider = $this->getCache();
        require ModuleHelper::getLayoutPath('mod_pixelcms_slider', $params->get('layout', 'default'));
    }
}

