<?php
/**
 * @package    pixelcms_slider
 *
 * @author     christophf <your@email.com>
 * @copyright  A copyright
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       http://your.url.com
 */

use Joomla\CMS\Helper\ModuleHelper;

defined('_JEXEC') or die;

if (!class_exists('\pixelCMS\Slider')) {
    require_once (__DIR__ . DS . 'Slider.php');
}

$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx'));
$size = htmlspecialchars($params->get('size', 2560));
$document = JFactory::getDocument();

$api_token = JFactory::getApplication()->get('pixel_cms_token');

$curl = curl_init();

$parameters = [
	'api_token'=> $api_token,
];

$query = http_build_query($parameters);

$url = "https://cms.pixel-kraft.de/api/v1/sliders?$query";

curl_setopt_array($curl, array(
	CURLOPT_URL => $url,
	CURLOPT_RETURNTRANSFER => true,
	CURLOPT_ENCODING => "",
	CURLOPT_MAXREDIRS => 10,
	CURLOPT_TIMEOUT => 5,
	CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
	CURLOPT_CUSTOMREQUEST => "GET",
	CURLOPT_POSTFIELDS => "",
	CURLOPT_HTTPHEADER => array(
		"accept: application/json"
	),
));

$response = curl_exec($curl);
$err = curl_error($curl);

curl_close($curl);

$slider = json_decode($response)[0];

$slides = array_filter($slider->slides, function($slide){
	return $slide->image;
});

$id = uniqid('slider-');

$slide_count	= count($slides);
// 2 slides wären 8 Sekunden
$pause			= 5;
$transition		= 1;
$duration		= 1*$pause+($slide_count-1)*($transition+$pause+$transition);
$s 				= 100 / $duration;
$time 			= 0;

echo '<div id="'.$id.'" class="slider-container"><div class="slider js-blur"><div class="slider-wrap header-image">';

foreach ($slides as $index => $slide) {
	$thumb = preg_replace('/(^(?!http)(?:(?!thumb).)*)\.(jpe?g|png)/', "$1.$size.$2", $slide->image->url);
	$style = [];
	$style[] = "background-image: url('https://cms.pixel-kraft.de$thumb')";
	if ($slide->image->position) {
		$posX = ($slide->image->position->x * 100);
		$posY = ($slide->image->position->y * 100);
		$style[] = "background-position: $posX% $posY%";
	}
	$style = implode(';', $style);
	echo "\t\t\t<div id='slide-$index' class='slide' style=\"$style\">\n";

	require ModuleHelper::getLayoutPath('mod_pixelcms_slider', $params->get('layout', 'default'));

	echo "\t\t\t</div>\n";
	if ($index==0) {
		$keys = "0% { -webkit-transform: translateX(0%) translateZ(0);transform: translateX(0%) translateZ(0);}";
		$time+=$s*$pause;
		$keys .= "$time% { -webkit-transform: translateX(0%) translateZ(0);transform: translateX(0%) translateZ(0);}";
	} else {
		$time+=$s*$transition;
		$keys .= "$time% { -webkit-transform: translateX(-".($index)."00%) translateZ(0);transform: translateX(-".($index)."00%) translateZ(0);}";
		$time+=$s*$pause;
		$keys .= "$time% { -webkit-transform: translateX(-".($index)."00%) translateZ(0);transform: translateX(-".($index)."00%) translateZ(0);}";
	}
}
echo '</div></div>';
echo "</div>";

$ua = htmlentities($_SERVER['HTTP_USER_AGENT'], ENT_QUOTES, 'UTF-8');
if (preg_match('~MSIE|Internet Explorer~i', $ua) || (strpos($ua, 'Trident/7.0; rv:11.0') !== false)) {
	$document->addScriptDeclaration("
		document.addEventListener('DOMContentLoaded', function (event) {
			var slider = document.getElementById('$id').firstElementChild;
			slider.style.animation = 'none';
			setTimeout(function(){
			    slider.style.animation = '';
			}, 100);
		});"
	);
}

$document->addStyleDeclaration(".slider-container{height:100%;width:100%;overflow:hidden;transform:translateZ(0);background-color:#000; }.slider{ position: relative; height: 100%; -webkit-animation: cycle  {$duration}s cubic-bezier(.55,0,.1,1) infinite; animation: cycle {$duration}s cubic-bezier(.55,0,.1,1) infinite; } @-webkit-keyframes cycle { $keys } @keyframes cycle { $keys }.slide{display: flex;align-items: center;justify-content: center;max-height:inherit;flex-shrink:0;background:#8E8E8E 50% 50%/cover no-repeat;width:100%;}.slider-wrap{height:100%;display:flex!important;width:100%;}");
