<?php
/**
 * @package    pixelslider
 *
 * @author     christophf <your@email.com>
 * @copyright  A copyright
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       http://your.url.com
 */

defined('_JEXEC') or die;

?>

<div class="uk-position-relative uk-visible-toggle uk-dark" tabindex="-1" uk-slideshow="<?php echo $ukSlideOpts; ?>">
  <ul class="uk-slideshow-items"><?php
    foreach ($slides as $index => $slide) {
        $thumb = preg_replace('/(^(?!http)(?:(?!thumb).)*)\.(jpe?g|png)/', "$1.$size.$2", $slide->image->url);
        $style = [];
        $style[] = "background-image: url('https://cms.pixel-kraft.de$thumb')";
        if ($slide->image->position) {
            $posX = ($slide->image->position->x * 100);
            $posY = ($slide->image->position->y * 100);
            $style[] = "background-position: $posX% $posY%";
        }
        $style = implode(';', $style);
        echo "<li><div style=\"$style\" uk-cover></div>";
        echo "<div class=\"slide__content\">";
        echo "<div class=\"slide__inner__content\">";
        if ($slide->title) {
            echo "<h1 uk-slideshow-parallax=\"x: 100,-100\"><span>$slide->title</span></h1>";
        }
        if ($slide->subtitle) {
            echo "<h2 uk-slideshow-parallax=\"x: 200,-200\"><span>$slide->subtitle</span></h2>";
        }
        echo "</div>"; // slide-inner-content
        echo "</div>"; // slide-content
        echo "</li>";
    }
  ?></ul>
  <a class="uk-position-center-left uk-position-small uk-hidden-hover" href="#" uk-slidenav-previous uk-slideshow-item="previous"></a>
  <a class="uk-position-center-right uk-position-small uk-hidden-hover" href="#" uk-slidenav-next uk-slideshow-item="next"></a>
</div>
