<?php
/**
 * @package    pixelslider
 *
 * @author     christophf <your@email.com>
 * @copyright  A copyright
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       http://your.url.com
 */

use Joomla\CMS\Helper\ModuleHelper;

defined('_JEXEC') or die;

$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx'));

$document = JFactory::getDocument();
$globalParams = JComponentHelper::getParams('com_pixelcms_articles');

// Get Config Params
$api_token = $globalParams->get('pixel_cms_token');

$document->addStyleSheet(JURI::base(true) . '/media/uikit/css/uikit.min.css', [
    'version' => '3.2.6',
]);
$document->addScript(JURI::base(true) . '/media/uikit/js/uikit.js', [
    'version' => '3.2.6',
]);
$document->addScript(JURI::base(true) . '/media/uikit/js/uikit-icons.min.js', [
    'version' => '3.2.6',
]);

$size = htmlspecialchars($params->get('size', 2560));

$curl = curl_init();

$parameters = [
    'api_token'=> $api_token,
];

$query = http_build_query($parameters);

$url = "https://cms.pixel-kraft.de/api/v1/sliders?$query";

curl_setopt_array($curl, array(
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 5,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "GET",
    CURLOPT_POSTFIELDS => "",
    CURLOPT_HTTPHEADER => array(
        "accept: application/json"
    ),
));

$response = curl_exec($curl);
$err = curl_error($curl);

curl_close($curl);

$slider = json_decode($response)[0];

$slides = array_filter($slider->slides, function($slide){
    return $slide->image;
});

$ukSlideOpts = implode('; ', [
   'autoplay: ' . $params->get('autoplay', true),
   'animation: ' . $params->get('animation', 'slide'),
   'ratio: ' . $params->get('ratio', '1100:525'),
   'autoplay-interval: ' . $params->get('autoplay_interval', '7000'),
]);

require ModuleHelper::getLayoutPath('mod_pixelslider', $params->get('layout', 'default'));
