<?php
/**
 * Created by PhpStorm.
 * User: christophf
 * Date: 10.07.2018
 * Time: 17:53
 */

namespace pixelCMS;

use JCache;
use JFactory;
use Joomla\CMS\Helper\ModuleHelper;

class Banner {
    protected $cache;

    public function __construct()
    {

        $this->cache = new JCache([]);
        $this->cache->setCaching(true);
    }

    private function getBanner() {
        $curl = curl_init();
        $api_token = JFactory::getApplication()->get('pixel_cms_token');
        $parameters = [
            'api_token'=> $api_token,
        ];

        $query = http_build_query($parameters);

        $url = "https://cms.pixel-kraft.de/api/v1/banner?$query";

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 5,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_POSTFIELDS => "",
            CURLOPT_HTTPHEADER => array(
                "accept: application/json"
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);

        return $response;
    }

    public function getCache()
    {
        $banner = $this->cache->get('banner', 'pixelcms_banner');

        if (empty($banner)) {
            $banner = $this->getBanner();
            $this->cache->store($banner, 'banner', 'pixelcms_banner');
        }

        return json_decode($banner);
    }

    public function display($params)
    {
        $banner = $this->getCache();
        require ModuleHelper::getLayoutPath('mod_pixelcms_banner', $params->get('layout', 'default'));
    }
}

