<?php
/**
 * Created by PhpStorm.
 * User: christophf
 * Date: 10.07.2018
 * Time: 17:53
 */

namespace pixelCMS;

use JCache;
use JComponentHelper;
use Joomla\CMS\Helper\ModuleHelper;

class Banner {
    protected $cache;
    private static $bannerIndex = 0;

    public function __construct()
    {
        $this->cache = new JCache([]);
        $this->cache->setCaching(true);
    }

    private function getBanner() {
        $curl = curl_init();
	    $api_token = JComponentHelper::getParams('com_pixelcms_articles')->get('pixel_cms_token');
        $parameters = [
            'api_token'=> $api_token,
            'prefer_video' => true,
        ];

        $query = http_build_query($parameters);

        $url = "https://cms.pixel-kraft.de/api/v1/banner/" .  self::$bannerIndex . "?$query";

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 5,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_POSTFIELDS => "",
            CURLOPT_HTTPHEADER => array(
                "accept: application/json"
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);

        return $response;
    }

    public function getCache()
    {
    	$cacheKey = 'banner' . self::$bannerIndex;
        $banner = $this->cache->get($cacheKey , 'pixelcms_banner');

        if (empty($banner)) {
            $banner = $this->getBanner();
            $this->cache->store($banner, $cacheKey, 'pixelcms_banner');
        }

        return json_decode($banner);
    }

    public function display($params)
    {
        $banner = $this->getCache();

        require ModuleHelper::getLayoutPath('mod_pixelcms_banner', $params->get('layout', 'default'));

        self::$bannerIndex += 1;
    }
}

