<?php
/**
 * @package    pixelcms_teams
 *
 * @author     christophf <your@email.com>
 * @copyright  A copyright
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       http://your.url.com
 */

defined('_JEXEC') or die;

$document = JFactory::getDocument();

$document->addStyleSheet('https://fonts.googleapis.com/icon?family=Material+Icons');

if (!class_exists('Pixelcms_articlesController')) {
    require_once (JPATH_SITE .DS. 'components' .DS. 'com_pixelcms_articles' .DS. 'controller.php');
}

$itemId = $params->get('pixelcms_menu_id');

if (class_exists('MenusHelper')) {
	$associations = MenusHelper::getAssociations($itemId);

	if (!empty($associations)) {
		$lang = JFactory::getLanguage();
		$langCode = $lang->getTag();
		$langCodeShort = substr($langCode, 0, 2);

		$itemId = $associations[$langCode];
	}
}

$app = JFactory::getApplication();
$jinput = $app->input;
$menu = $app->getMenu()->getItem($itemId);

$old_jinput = [
    'Itemid' => $jinput->get('Itemid'),
    'view' => $jinput->get('view'),
    'option' => $jinput->get('option'),
    'layout' => $jinput->get('layout'),
    'articleId' => $jinput->get('articleId', null),
	'limit' => $jinput->get('limit'),
	'show_page_heading' => $jinput->get('show_page_heading'),
	'intro_length' => $jinput->get('intro_length'),
    'model' => $jinput->get('model', null),
];

$view = $params->get('pixelcms_module');

$jinput->set('Itemid', $itemId);
$jinput->set('view', $params->get('pixelcms_module'));
$jinput->set('pixelcms_category_id', $params->get('pixelcms_category_id'));
$jinput->set('pixelcms_filter', $params->get('pixelcms_filter'));
$jinput->set('limit', $params->get('limit'));
$jinput->set('intro_length', $params->get('intro_length'));
$jinput->set('articleId', $params->get('articleId', null));
$jinput->set('show_page_heading', false);

$jinput->set('option', 'com_pixelcms_articles');
$jinput->set('layout', 'default');
if ($view == 'tracktorpool_products') {
	$old_jinput['speed'] = $jinput->get('speed');
    $jinput->set('layout',                      $params->get('layout_tracktorpool_products', 'default'));
    $jinput->set('tracktorpool_alias',          $menu->query['tracktorpool_alias']);
	$jinput->set('model',                       $menu->query['model']);
	$jinput->set('speed',                       $params->get('speed', null));
} else if ($view == 'pixelcms_articles') {
    $jinput->set('pixelcms_category_id',        $params->get('pixelcms_category_id'));
    $jinput->set('pixelcms_filter',             $params->get('pixelcms_filter'));
    $jinput->set('layout',                      $params->get('layout_pixelcms_articles', 'default'));
} else if ($view == 'pixelcms_events') {
	$jinput->set('pixelcms_filter',             $params->get('pixelcms_filter'));
	$jinput->set('layout',                      $params->get('layout_pixelcms_events', 'default'));
} else if ($view == 'pixelcms_news') {
    $jinput->set('layout',                      $params->get('layout_pixelcms_news', 'default'));
} else if ($view == 'pixelcms_teams') {
    $jinput->set('articleId',                   $params->get('teamId', null));
    $jinput->set('layout',                      $params->get('layout_pixelcms_teams', 'default'));
} else if ($view == 'pixelcms_manufacturers') {
    $jinput->set('layout',                      $params->get('layout_pixelcms_manufacturers', 'default'));
    $jinput->set('pixelcms_category_id',        $params->get('pixelcms_manufacturers_category_id', 0));
} else if ($view == 'landwirt_content') {
	$old_jinput['nummer'] = $jinput->get('nummer');
	$old_jinput['landwirt_customer'] = $jinput->get('landwirt_customer');

	$jinput->set('layout',                      $params->get('layout_landwirt_content', 'default'));
	$jinput->set('landwirt_customer',           $menu->query['landwirt_customer']);
    $jinput->set('landwirt_module',             $params->get('landwirt_module', 'Articles'));
    $jinput->set('nummer',                      $params->get('nummer', null));
}

$controller = new Pixelcms_articlesController();

$lang = JFactory::getLanguage();
$lang->load('com_pixelcms_articles', JPATH_SITE);

$controller->setProperties([
    'basePath' => JPATH_SITE .DS. 'components' .DS. 'com_pixelcms_articles',
    'name' => 'pixelcms_articles',
    'is_module' => true,
    'option' => 'com_pixelcms_articles',
    'module_name' => $module->module,
    'default_view' => $params->get('pixelcms_module'),
    'show_page_heading' => false,
    'default_layout' => $jinput->get('layout', 'default'),
    'paths' => [
        'view' => [
            JPATH_SITE .DS. 'components' .DS. 'com_pixelcms_articles' . DS . 'views' . DS,
        ],
    ],
]);
$controller->addModelPath(JPATH_SITE .DS. 'components' .DS. 'com_pixelcms_articles' . DS . 'models' . DS);

if ($params->get('legacy_mode') === '0') {
    echo "<div class=\"$view-wrapper mod_cms-wrapper\">";
    $controller->display(false);
    echo '</div>';
} else {
    $controller->display(false);
}

$jinput->set('Itemid', $old_jinput['Itemid']);
$jinput->set('view', $old_jinput['view']);
$jinput->set('option', $old_jinput['option']);
$jinput->set('layout', $old_jinput['layout']);
$jinput->set('articleId', $old_jinput['articleId']);
$jinput->set('limit', $old_jinput['limit']);
$jinput->set('intro_length', $old_jinput['intro_length']);
$jinput->set('show_page_heading', $old_jinput['show_page_heading']);
$jinput->set('model', $old_jinput['model']);

if ($view == 'landwirt_content') {
	$jinput->set('nummer', $old_jinput['nummer']);
	$jinput->set('landwirt_customer', $old_jinput['landwirt_customer']);
} else if ($view == 'tracktorpool_products') {
	$jinput->set('speed', $old_jinput['speed']);
}
