<?php

defined('_JEXEC') or die;

jimport( 'joomla.form.fields.list' );
JFormHelper::loadFieldClass('list');

class JFormFieldTeams extends JFormFieldList {
    protected $type = 'Teams';
    const API_VERSION = 'v1';
    const CMS_URL = 'https://cms.pixel-kraft.de';

    protected function getOptions()
    {
        $data = [
            0 => (object) [
                'value' => "",
                'text' => 'Alle',
            ],
        ];

	    $globalParams = JComponentHelper::getParams('com_pixelcms_articles');

	    $api_token = $globalParams->get('pixel_cms_token');

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => static::CMS_URL . '/api/' . static::API_VERSION . '/' . "departments" . "?api_token=$api_token",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 2,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_POSTFIELDS => "",
            CURLOPT_HTTPHEADER => array(
                "accept: application/json"
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);

        $pixel_articles = json_decode($response);

        foreach ($pixel_articles as $article) {
            $data[] = (object) [
                'value' => $article->id,
                'text' => "($article->id) $article->title",
            ];
        }

        return $data;
    }
}
