<?php
/**
 * @package    pixelcms_teams
 *
 * @author     christophf <your@email.com>
 * @copyright  A copyright
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       http://your.url.com
 */

defined('_JEXEC') or die;

$document = JFactory::getDocument();
if (!class_exists('Pixelcms_articlesController')) {
    require_once (JPATH_SITE .DS. 'components' .DS. 'com_pixelcms_articles' .DS. 'controller.php');
}

$itemId = $params->get('pixelcms_menu_id');

if (class_exists('MenusHelper')) {
	$associations = MenusHelper::getAssociations($itemId);

	if (!empty($associations)) {
		$lang = JFactory::getLanguage();
		$langCode = $lang->getTag();
		$langCodeShort = substr($langCode, 0, 2);

		$itemId = $associations[$langCode] ?? $itemId;
	}
}

$app = JFactory::getApplication();
$jinput = $app->input;
$menu = $app->getMenu()->getItem($itemId);

$old_jinput = [
    'Itemid' => $jinput->get('Itemid'),
    'view' => $jinput->get('view'),
    'option' => $jinput->get('option'),
    'layout' => $jinput->get('layout'),
    'articleId' => $jinput->get('articleId', null),
	'limit' => $jinput->get('limit'),
	'page_size' => $jinput->get('page_size'),
	'page' => $jinput->get('page'),
	'show_page_heading' => $jinput->get('show_page_heading'),
	'intro_length' => $jinput->get('intro_length'),
    'model' => $jinput->get('model', null),
    'legacy_mode' => $jinput->get('legacy_mode', '0'),
    'force_list' => $jinput->get('force_list', false),
    'show_archiv' => $jinput->get('show_archiv', true),
	'pixelcms_images_thumb_size' => $jinput->get('pixelcms_images_thumb_size'),
	'pixelcms_images_preview_size' => $jinput->get('pixelcms_images_preview_size'),
	'pixelcms_images_testimonial_size' => $jinput->get('pixelcms_images_testimonial_size'),
];

$view = $params->get('pixelcms_module');

$globalParams = JComponentHelper::getParams('com_pixelcms_articles');

$jinput->set('Itemid', $itemId);
$jinput->set('view', $params->get('pixelcms_module'));
$jinput->set('pixelcms_category_id', $params->get('pixelcms_category_id'));
$jinput->set('pixelcms_filter', $params->get('pixelcms_filter'));
$jinput->set('limit', $params->get('limit'));
$jinput->set('page', 0);
$jinput->set('intro_length', $params->get('intro_length'));
$jinput->set('articleId', $params->get('articleId', null));
$jinput->set('show_page_heading', false);
$jinput->set('model', $params->get('model', null));
$jinput->set('is_module', true);
$jinput->set('legacy_mode', $params->get('legacy_mode'));
$jinput->set('page_size', $params->get('page_size', 15));

$jinput->set('pixelcms_images_thumb_size', $params->get('pixelcms_images_thumb_size', $old_jinput['pixelcms_images_thumb_size']));
$jinput->set('pixelcms_images_preview_size', $params->get('pixelcms_images_preview_size', $old_jinput['pixelcms_images_preview_size']));
$jinput->set('pixelcms_images_testimonial_size', $params->get('pixelcms_images_testimonial_size', $old_jinput['pixelcms_images_testimonial_size']));

$jinput->set('option', 'com_pixelcms_articles');
$jinput->set('layout', 'default');
if ($view == 'tracktorpool_products') {
    $old_jinput['speed'] = $jinput->get('speed');
    $jinput->set('limit',                       $params->get('limit', 20));
	if ($params->get('layout_tracktorpool_products') === 'carousel') {
		$jinput->set('limit',                   20);
	}
    $jinput->set('layout',                      $params->get('layout_tracktorpool_products', 'default'));
	if ($jinput->get('layout') === '_promo') {
		$jinput->set('articleId', 'rand');
	}
	$jinput->set('speed',                       $params->get('speed', null));
	$jinput->set('model',                       $menu->query['model']);
} else if ($view == 'pixelcms_articles') {
    $jinput->set('pixelcms_category_id',        $params->get('pixelcms_category_id'));
    $jinput->set('pixelcms_filter',             $params->get('pixelcms_filter'));
    $jinput->set('layout',                      $params->get('layout_pixelcms_articles', 'default'));
    $jinput->set('show_archiv',                 $params->get('show_archiv', false));
    $jinput->set('force_list',                  $params->get('force_list', 'default'));
} else if ($view == 'pixelcms_events') {
	$jinput->set('pixelcms_filter',             $params->get('pixelcms_filter'));
	$jinput->set('layout',                      $params->get('layout_pixelcms_events', 'default'));
} else if ($view == 'pixelcms_galleries') {
	$jinput->set('articleId',                   $params->get('pixelcms_gallery_id', null));
	$jinput->set('layout',                      $params->get('layout_pixelcms_galleries', 'default'));
} else if ($view == 'pixelcms_news') {
    $jinput->set('layout',                      $params->get('layout_pixelcms_news', 'default'));
    $jinput->set('pixelcms_category_id',        $menu->query['pixelcms_category_id']);
} else if ($view == 'pixelcms_teams') {
    $jinput->set('articleId',                   $params->get('teamId', null));
    $jinput->set('layout',                      $params->get('layout_pixelcms_teams', 'default'));
} else if ($view == 'pixelcms_manufacturers') {
    $jinput->set('layout',                      $params->get('layout_pixelcms_manufacturers', 'default'));
    $jinput->set('pixelcms_category_id',        $params->get('pixelcms_manufacturers_category_id', 0));
	$jinput->set('limit',                       $params->get('limit', 8));
} else if ($view == 'landwirt_content') {
	$old_jinput['nummer'] = $jinput->get('nummer');
	$old_jinput['landwirt_customer'] = $jinput->get('landwirt_customer');

	$jinput->set('layout',                      $params->get('layout_landwirt_content', 'default'));
	$jinput->set('landwirt_customer',           $menu->query['landwirt_customer']);
    $jinput->set('landwirt_module',             $params->get('landwirt_module', 'Articles'));
    $jinput->set('nummer',                      $params->get('nummer', null));
}

$controller = new Pixelcms_articlesController();

$lang = JFactory::getLanguage();
$lang->load('com_pixelcms_articles', JPATH_SITE);

$controller->setProperties([
    'basePath' => JPATH_SITE .DS. 'components' .DS. 'com_pixelcms_articles',
    'name' => 'pixelcms_articles',
    'is_module' => true,
    'option' => 'com_pixelcms_articles',
    'module_name' => $module->module,
    'default_view' => $params->get('pixelcms_module'),
    'show_page_heading' => false,
    'default_layout' => $jinput->get('layout', 'default'),
    'paths' => [
        'view' => [
            JPATH_SITE .DS. 'components' .DS. 'com_pixelcms_articles' . DS . 'views' . DS,
        ],
    ],
]);
$controller->addModelPath(JPATH_SITE .DS. 'components' .DS. 'com_pixelcms_articles' . DS . 'models' . DS);

$controller->display(false);

$jinput->set('is_module', false);
$jinput->set('Itemid', $old_jinput['Itemid']);
$jinput->set('view', $old_jinput['view']);
$jinput->set('option', $old_jinput['option']);
$jinput->set('layout', $old_jinput['layout']);
$jinput->set('articleId', $old_jinput['articleId']);
$jinput->set('limit', $old_jinput['limit']);
$jinput->set('page_size', $old_jinput['page_size']);
$jinput->set('page', $old_jinput['page']);
$jinput->set('intro_length', $old_jinput['intro_length']);
$jinput->set('show_page_heading', $old_jinput['show_page_heading']);
$jinput->set('model', $old_jinput['model']);
$jinput->set('legacy_mode', $old_jinput['legacy_mode']);
$jinput->set('force_list', $old_jinput['force_list']);
$jinput->set('show_archiv', $old_jinput['show_archiv']);
$jinput->set('pixelcms_images_thumb_size', $old_jinput['pixelcms_images_thumb_size']);
$jinput->set('pixelcms_images_preview_size', $old_jinput['pixelcms_images_preview_size']);
$jinput->set('pixelcms_images_testimonial_size', $old_jinput['pixelcms_images_testimonial_size']);

if ($view == 'landwirt_content') {
	$jinput->set('nummer', $old_jinput['nummer']);
	$jinput->set('landwirt_customer', $old_jinput['landwirt_customer']);
} else if ($view == 'tracktorpool_products') {
	$jinput->set('speed', $old_jinput['speed']);
}
