<?php
/**
 * @package    pixelcms_headers
 *
 * @author     christophf <your@email.com>
 * @copyright  A copyright
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       http://your.url.com
 */

use Joomla\CMS\Helper\ModuleHelper;

defined('_JEXEC') or die;

$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx'));
$size = htmlspecialchars($params->get('size', 2000));

if (!function_exists('getThumb'))
{
	function getThumb($url, $size = 2000)
	{
		if (!$url) return null;

		return preg_replace('/(^(?!http)(?:(?!thumb).)*)\.(jpe?g|png)/', "$1.$size.$2", $url);
	}
}

$disabled = false;

$article = JTable::getInstance("content");
$article_id = JFactory::getApplication()->input->get('id', null);
$view = JFactory::getApplication()->input->get('view');
$intro_image = null;

$style = [];

$default_image = $params->get('default_image');

if (!function_exists('disabledTitleImage')) {
	function disabledTitleImage($model): bool
	{
		if (!$model) return false;
		$params = $model->getState('params');
		return (bool) $params->get('disable_title_image', false);
	}
}

// Joomla Intro Image
if ($article_id) {
	$article->load($article_id);
	if ($article->language != 'de-DE' && $assoc) {
		$associations = JLanguageAssociations::getAssociations('com_content', '#__content', 'com_content.item', $article_id);
		$article_id = $app->getMenu()->getItem($associations['de-DE'])->query['id'];
		$article->load($article_id);
	}
	$images = json_decode($article->images);

	if ($images->image_intro) {
		$intro_image = ((strpos($images->image_intro, '//') !== false) ? '' : '/') . $images->image_intro;
	}
}

// Article Image
$article_id =  JFactory::getApplication()->input->get('articleId', $article_id || null);
if ($params->get('articles', true) && !$intro_image && $article_id && $view == 'pixelcms_articles') {
	$controller = JControllerLegacy::getInstance('pixelcms_articles');
	$model = $controller->load('pixelcms_articles');
	$article = $model->getArticle();
	if (isset($article->data)) $article = $article->data;
	$disabled = disabledTitleImage($model);
	if ($article && $article->titleimage) {
		$thumb = getThumb($article->titleimage->url, $size);
		$intro_image = "https://cms.pixel-kraft.de$thumb";
		if ($article->titleimage->position) {
			$posX = ($article->titleimage->position->x * 100);
			$posY = ($article->titleimage->position->y * 100);
			$style[] = "background-position: $posX% $posY%";
		}
	}
}

// Event image
if ($params->get('events', true) && !$intro_image && $article_id && $view == 'pixelcms_events') {
	$controller = JControllerLegacy::getInstance('pixelcms_articles');
	$model = $controller->load('pixelcms_events');
	$article = $model->getArticle();
	if (isset($article->data)) $article = $article->data;
    $disabled = disabledTitleImage($model);
	if ($article && $article->image) {
		$thumb = getThumb($article->image->url, $size);
		$intro_image = "https://cms.pixel-kraft.de$thumb";
		if ($article->image->position) {
			$posX = ($article->image->position->x * 100);
			$posY = ($article->image->position->y * 100);
			$style[] = "background-position: $posX% $posY%";
		}
	}
}

// News Image
if ($params->get('news', true) && !$intro_image && $article_id && $view == 'pixelcms_news') {
	$controller = JControllerLegacy::getInstance('pixelcms_articles');
	$model = $controller->load('pixelcms_news');
	$article = $model->getNews();
	if (isset($article->data)) $article = $article->data;
    $disabled = disabledTitleImage($model);
	if ($article && count($article->images) > 0) {
		$intro_image = "{$article->images[0]}";
	}
}

$category = JFactory::getApplication()->input->get('pixelcms_category_id', null);

// Category Image
if (!$intro_image && $category) {
	$controller = JControllerLegacy::getInstance('pixelcms_articles');
	$model = $controller->load('pixelcms_articles');
	$article = $model->getCategory();
	if ($article && $article->image) {
		$thumb = getThumb($article->image->url, $size);
		$intro_image = "https://cms.pixel-kraft.de$thumb";
		if ($article->image->position) {
			$posX = ($article->image->position->x * 100);
			$posY = ($article->image->position->y * 100);
			$style[] = "background-position: $posX% $posY%";
		}
	}
}

// Category Image for current Article [Fallback]
if ($params->get('articles', true) && !$intro_image && $article && $article->category->image) {
	$thumb = getThumb($article->category->image->url, $size);
	$intro_image = "https://cms.pixel-kraft.de$thumb";
	if ($article->category->image->position) {
		$posX = ($article->category->image->position->x * 100);
		$posY = ($article->category->image->position->y * 100);
		$style[] = "background-position: $posX% $posY%";
	}
}
if ($disabled) {
    // Don't do anything
} else if ($intro_image || $default_image) {
    if ($intro_image) {
        $style[] = "background-image: url('$intro_image')";
    } else {
        $style[] = "background-image: url('$default_image')";
    }
    $style = implode(';', $style);
    echo "<div class=\"header-image\" style=\"$style\"></div>";
} else {
    echo "<div class=\"header-image header-image--empty\"></div>";
}

