<?php
/**
 * @package    pixelcms_headers
 *
 * @author     christophf <your@email.com>
 * @copyright  A copyright
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       http://your.url.com
 */

defined('_JEXEC') or die;

use Joomla\CMS\Table\Content;
use Joomla\CMS\Table\Category;
use Joomla\CMS\Factory;

$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx'));
$size = htmlspecialchars($params->get('size', 2000));

if (!function_exists('getThumb'))
{
	function getThumb($url, $size = 2000)
	{
		if (!$url) return null;

		return preg_replace('/(^(?:(?!http)|https:\/\/cms\.pixel-kraft\.de)(?:(?!thumb).)*?)(?:\.\d+)?\.(jpe?g|png)$/', "$1.$size.$2", $url);
	}
}

$disabled = false;

/** @var \Joomla\CMS\Table\Content $article */
$article = Content::getInstance('content');
/** @var \Joomla\CMS\Table\Category $category */
$category = Category::getInstance("category");

$input = Factory::getApplication()->input;

$article_id = $input->get('id', null);
$view = $input->get('view');
$intro_image = null;

$style = [];

$default_image = $params->get('default_image');

if (!function_exists('disabledTitleImage')) {
	function disabledTitleImage($model): bool
	{
		if (!$model) return false;
		$params = $model->getState('params');
		return (bool) $params->get('disable_title_image', false);
	}
}

// Joomla Intro Image
if ($article_id) {
    $articleFound = false;

    if ($view === 'article') {
        $articleFound = $article->load($article_id);

        if ($article->language != 'de-DE' && isset($assoc)) {
            $associations = JLanguageAssociations::getAssociations('com_content', '#__content', 'com_content.item', $article_id);
            $article_id = $app->getMenu()->getItem($associations['de-DE'])->query['id'];
            $articleFound = $article->load($article_id);
        }
        $images = json_decode($article->images);

        if (is_object($images) && $images->image_fulltext) {
            $intro_image = ((strpos($images->image_fulltext, '//') !== false) ? '' : '/') . $images->image_fulltext;
        } else if ($params->get('use_intro_image_as_fallback', true) && $images->image_intro) {
            $intro_image = ((strpos($images->image_intro, '//') !== false) ? '' : '/') . $images->image_intro;
        }
    }


    if (!$intro_image) {
        // We have an article but no category jet
        if ($view === 'category') {
            $catFound = $category->load($article_id);
        } else if ($articleFound) {
            $catFound = $category->load($article->get('catid'));
        }

        if ($catFound) {
            for ($i=$category->level; $i > 0 && !$intro_image; $i--) {
                $parentId = $category->parent_id;

                $attrs = json_decode($category->params);

                if ($attrs && $attrs->image !== '') {
                    $intro_image = $attrs->image;
                } else {
                    $category = JTable::getInstance("category");
                    $category->load($parentId);
                }
            }
        }
    }
}

// Joomla Category Intro Image
//if ($article_id && !$intro_image) {
//    $category->load($article_id);
//
//    for ($i=$category->level; $i !== 0 && !$intro_image; $i--) {
//        $parentId = $category->parent_id;
//
//        $attrs = json_decode($category->params);
//
//        if ($attrs && $attrs->image !== '') {
//            $intro_image = $attrs->image;
//        } else {
//            $category = JTable::getInstance("category");
//            $category->load($parentId);
//        }
//    }
//}

// Article Image
$article_id =  $input->get('articleId', $article_id || null);
if ($params->get('articles', true) && !$intro_image && $article_id && $view == 'pixelcms_articles') {
	$controller = JControllerLegacy::getInstance('pixelcms_articles');
	$model = $controller->load('pixelcms_articles');
	$article = $model->getArticle();
	if (isset($article->data)) $article = $article->data;
	$disabled = disabledTitleImage($model);
	if ($article && $article->titleimage) {

		$thumb = getThumb($article->titleimage->url, $size);
		$intro_image = "https://cms.pixel-kraft.de$thumb";
		if ($article->titleimage->position) {
			$posX = ($article->titleimage->position->x * 100);
			$posY = ($article->titleimage->position->y * 100);
			$style[] = "background-position: $posX% $posY%";
		}
	}
}

// Event image
if ($params->get('events', true) && !$intro_image && $article_id && $view == 'pixelcms_events') {
	$controller = JControllerLegacy::getInstance('pixelcms_articles');
	$model = $controller->load('pixelcms_events');
	$article = $model->getArticle();
	if (isset($article->data)) $article = $article->data;
    $disabled = disabledTitleImage($model);
	if ($article && $article->image) {
		$thumb = getThumb($article->image->url, $size);
		$intro_image = "https://cms.pixel-kraft.de$thumb";
		if ($article->image->position) {
			$posX = ($article->image->position->x * 100);
			$posY = ($article->image->position->y * 100);
			$style[] = "background-position: $posX% $posY%";
		}
	}
}

// News Image
if ($params->get('news', true) && !$intro_image && $article_id && $view == 'pixelcms_news') {
	$controller = JControllerLegacy::getInstance('pixelcms_articles');
	$model = $controller->load('pixelcms_news');
	$article = $model->getNews();
	if (isset($article->data)) $article = $article->data;
    $disabled = disabledTitleImage($model);
	if ($article && count($article->images) > 0) {
		$intro_image = "{$article->images[0]}";
	}
}

$category = $input->get('pixelcms_category_id', null);

// Category Image
if (!$intro_image && $category && $view == 'pixelcms_articles') {
	$controller = JControllerLegacy::getInstance('pixelcms_articles');
	$model = $controller->load('pixelcms_articles');
	$article = $model->getCategory();
	if ($article && $article->image) {
		$thumb = getThumb($article->image->url, $size);
		$intro_image = "https://cms.pixel-kraft.de$thumb";
		if ($article->image->position) {
			$posX = ($article->image->position->x * 100);
			$posY = ($article->image->position->y * 100);
			$style[] = "background-position: $posX% $posY%";
		}
	}
}

// Menu Image Override for pixelCMS Component
if (!$intro_image && $view == 'pixelcms_manufacturers') {
    $intro_image = getThumb(urldecode($input->getString('header_image_url')), $size);
    $posY = $input->getInt('header_image_offset', 50);

    $style[] = "background-position: 50% $posY%";
}

// Category Image for current Article [Fallback]
if ($params->get('articles', true) && !$intro_image && $article && isset($article->category) && isset($article->category->image)) {
	$thumb = getThumb($article->category->image->url, $size);
	$intro_image = "https://cms.pixel-kraft.de$thumb";
	if ($article->category->image->position) {
		$posX = ($article->category->image->position->x * 100);
		$posY = ($article->category->image->position->y * 100);
		$style[] = "background-position: $posX% $posY%";
	}
}
if ($disabled) {
    // Don't do anything
} else if ($intro_image || $default_image) {
    if ($intro_image) {
        $style[] = "background-image: url('$intro_image')";
    } else {
        $style[] = "background-image: url('$default_image')";
    }
    $style = implode(';', $style);
    echo "<div class=\"header-image\" style=\"$style\"></div>";
} else {
    echo "<div class=\"header-image header-image--empty\"></div>";
}

