<?php
/**
 * Created by PhpStorm.
 * User: christophf
 * Date: 24.01.2019
 * Time: 11:34
 */


class CookieConsentContent
{
    public $message;
    public $dismiss;
    public $allow;
    public $deny;
    public $link;
    public $href;

    private $cast = [
        'message' => 'translation',
        'dismiss' => 'translation',
        'allow' => 'translation',
        'deny ' => 'translation',
        'link' => 'translation',
        'href' => 'menuItem'
    ];

    public function __construct(\Joomla\Registry\Registry $params)
    {
        $properties = get_object_vars($this);
        foreach($properties as $prop => $value) {
            $this->{$prop} = $this->castAttribute($prop, $params->get($prop, $value));
        }
    }

    private function castAttribute(string $prop, $value)
    {
        if (isset($this->cast[$prop]) && $propType = $this->cast[$prop]) {
            switch ($propType) {
                case 'translation':
                    $translation = $value ?? strtoupper($prop);
                    return JText::_("MOD_COOKIECONSENT_$translation");
                case 'menuItem':
                    return $this->getLink($value);
            }
        }
        return $value;
    }

    private function getLink($ItemId)
    {
        $associations = MenusHelper::getAssociations($ItemId);
        if ($associations) {
            $lang = JFactory::getLanguage()->getTag();
            $ItemId = $associations[$lang] ?? $ItemId;
        }

        return JRoute::_("index.php?Itemid=$ItemId");
    }
}

class CookieConsentConfig
{
    public $theme;
    public $position;
    public $type;
    public $content;

    private $params;

    protected $cast = [
        'content' => 'CookieConsentContent',
    ];

    public function __construct(\Joomla\Registry\Registry $params)
    {
        $this->params = $params;

        $properties = get_object_vars($this);
        foreach($properties as $prop => $value) {
            $this->{$prop} = $this->castAttribute($prop, $params->get($prop, $value));
        }
    }

    private function castAttribute(string $prop, $value)
    {
        if (isset($this->cast[$prop]) && $propType = $this->cast[$prop]) {
            switch ($propType) {
                case 'CookieConsentContent':
                    return new CookieConsentContent($this->params);
                case 'object':
                    return (object) $value;
                case 'integer':
                case 'int':
                    return (int) $value;
                case 'boolean':
                case 'bool':
                    return (bool) $value;
            }
        }
        return $value;
    }

    public function __call($name, $arguments)
    {
        $prefix = count($arguments) === 1 ? 'set' : 'get';

        $methodName = "$prefix$name";

        if (method_exists(get_class($this), $methodName))
        {
            if ($prefix === 'get') return $this->{$methodName}();
            return $this->{$methodName}($arguments[0]);
        }

        if (property_exists(get_class($this), $name)) {
            if ($prefix === 'set') $this->$name = $arguments[0];
            return $this->$name;
        }

        throw new \Exception("Property $name doesn't exist.");
    }

    public function __toString()
    {
        return json_encode(array_filter((array) $this));
    }
}

class CookieConsent
{
    protected $id;
    protected $doc;
    protected $baseUrl;
    protected $assetsUrl;
    protected $entryPoint = 'main';
    protected $manifest = [];
    protected $config;

    public function __construct(CookieConsentConfig $config)
    {
        $this->doc = JFactory::getDocument();
        $this->baseUrl = JUri::root(true);
        $this->assetsUrl = "$this->baseUrl/media/mod_cookieconsent/assets";
        $this->config = $config;
        $this->manifest = json_decode(file_get_contents(JPATH_ROOT . '/media/mod_cookieconsent/manifest.json'), true);
    }

    private function attachScripts()
    {
        $this->addScript($this->manifest["$this->entryPoint.js"] );
    }

    private function attachStyles()
    {
        $this->addStyleSheet($this->manifest["$this->entryPoint.css"]);
    }

    private function addScript(string $script)
    {
        $this->doc->addScript("$this->assetsUrl/$script", [
            'defer' => true,
            'async' => true,
        ]);
    }

    private function createStartScript()
    {
        $html[] = "window.addEventListener(\"load\", function(){ window.cookieconsent.initialise($this->config); });";

        return implode('', $html);
    }

    private function addStyleSheet(string $style)
    {
        $this->doc->addStyleSheet("$this->assetsUrl/$style");
    }

    public function render()
    {
        $this->attachScripts();
        $this->attachStyles();

        $this->doc->addScriptDeclaration($this->createStartScript());
    }
}
