<?php
/**
 * @package    carousel
 *
 * @author     christophf <your@email.com>
 * @copyright  A copyright
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       http://your.url.com
 */

defined('_JEXEC') or die;

$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx'));

if (!class_exists('Siema')) {
    require_once JPATH_ROOT . '/modules/mod_carousel/Siema.php';
}

$siema = new Siema(new SiemaConfig($params));

$items = ($params->get('source') === 'items') ? new SiemaItems($params->get('items')) : new SiemaArticles($params->get('catId'), $params->get('introLength'));

// Sortiert Artikel
if ($params->get('articleSort', false) && $params->get('source') === 'articles') {
	$sort = $params->get('articleSort', false);
	$sortOrder = $params->get('articleSortOrder', 'asc');

	$sortArr = explode('.', $sort);
	$isCustomField = array_shift($sortArr) === 'fields';

	$isDate = $isCustomField && $items[0]->fields->{$sortArr[0]}->type === 'calendar';

	$items->usort(function(SiemaItem $a, SiemaItem $b) use ($sort, $sortOrder) {
		if ($sortOrder === 'desc') return $b->get($sort) <=> $a->get($sort);
		return $a->get($sort) <=> $b->get($sort);
	});
}

$siema->render($items, $moduleclass_sfx, $params->get('layout', 'default'), $params->get('rows', 1));
