<?php
    $CMS_URL = 'https://cms.pixel-kraft.de';

    foreach ($this->article as $article) {
        $classList['show_date'] = $this->params->get('show_date', '');

        $html[] = "<div class='cms_article {$this->compileClassList($classList)}'>";
        $link = JRoute::_("index.php?option=com_pixelcms_articles&view=pixelcms_articles&articleId=$article->id&Itemid=$this->item_id");
	    if ($article->titleimage) {
		    $thumb = $this->getThumbnail($article->titleimage->url, 500, false);
            if (in_array((int) $this->params->get('cut_images'), [1, 2])) {
                $html[] = "<a href='$link' class='cms_article__image' style='background-image: url({$this->params->get('pixel_cms_url')}/$thumb)'></a>";
            } else {
                $html[] = "<a href='$link' class='cms_article__image'><img src='{$this->params->get('pixel_cms_url')}/$thumb'></a>";
            }
        } else if ($article->images) {
		    $thumb = $this->getThumbnail($article->images[0]->url, 500, false);
		    if (in_array((int) $this->params->get('cut_images'), [1, 2])) {
                $html[] = "<a href='$link' class='cms_article__image cms_article__image--article-image' style='background-image: url({$this->params->get('pixel_cms_url')}/$thumb)'></a>";
            } else {
                $html[] = "<a href='$link' class='cms_article__image cms_article__image--article-image'><img src='{$this->params->get('pixel_cms_url')}/$thumb'></a>";
            }
	    } else {
	        $html[] = "<div class='cms_article__image cms_article__image--empty'></div>";
        }
        $html[] = "<div class='cms_article__content'>";

        $date = "<span class='cms_article__date'>" . DateTime::createFromFormat('Y-m-d H:i:s', $article->created_at)->format('d.m.Y') . "</span>";

        if ($this->params->get('show_date', 0) === 'before') {
            $html[] = $date;
        }
        $html[] = "<a href='$link'><h2 class='cms_article__headline'>$article->title</h2></a>";
        if ($this->params->get('show_date', 0) === 'after') {
            $html[] = $date;
        }

        $intro_text = $this->getIntro($article->content, $this->params->get('intro_length'));

	    $html[] = "<div class='cms_article__intro'>$intro_text</div>";
        $html[] = "<a class=\"cms_article__readmore\" href=\"$link\">Weiterlesen</a>";
        $html[] = "</div>"; // cms_article__content
        $html[] = "</div>"; // cms_article
    }
    if (!$this->article) {
         $html[] = '&nbsp;'; // Fix empty joomla modules
    }

    if ($this->params->get('legacy_mode', '0') === '0') {
        $containerClass = $this->getContainerClass();
        $articleCount = count($this->article);
        array_unshift($html, "<div class=\"$containerClass\" data-count=\"$articleCount\">");
        array_push($html, '</div>');
    }
    if ($this->params->get('show_page_heading')) {
        array_unshift($html, "<div class=\"page-header\"><h2 itemprop=\"headline\">{$this->params->get('page_title')}</h2></div>");
    }

    echo implode("\n", $html);
