<?php
$doc = JFactory::getDocument();

$lang = JFactory::getLanguage();
$langCode = $lang->getTag();
$langCodeShort = substr($langCode, 0, 2);
$jinput = JFactory::getApplication()->input;

$locale = $this->locale;

$ad = $this->ads;

$conditions = [
    'used' => 'Gebraucht',
    'new' => 'Neu',
];

JHtml::_('jquery.framework');

$doc->addScript( JUri::base(true) . '/media/com_pixelcms_articles/js/jquery.colorbox-min.js' );
$doc->addStyleSheet( JUri::base(true) . '/media/com_pixelcms_articles/css/colorbox.css' );

$script = "
    function goBack() {
        (window.sessionStorage.getItem('product_link')) ? window.location.replace(window.sessionStorage.getItem('product_link')) : window.history.back()
    };
	jQuery( document ).ready(function() {
		jQuery('.product__images__thumbs a').colorbox({
			rel:'gal',
			scrolling: false,
			maxHeight: '80%',
			maxWidth: '80%',
			fixed: true,
			className: 'droppics'
		});
	});
";
$doc->addScriptDeclaration( $script );

$html = '<div class="product">';
$html .= '<div class="product__images">';
if (count($ad->images) > 0) {
    $html .= "<img class=\"product__images__big\" src=\"{$ad->images[0]->href}\">";
    $html .= '<div class="product__images__thumbs">';
    foreach ($ad->images as $key => $image) {
        $html .= "<a href=\"$image->href\"><img class=\"product__images\" src=\"$image->href?width=150\"></a>";
    }
    $html .= '</div>';
} else {
    $html .= "<div class=\"product__images__big product__images__big--empty\"></div>";
}
$html .= '</div>';
$html .= '<div class="product__description">';
$html .= "<h1>" . implode(' ', [$ad->manufacturer->value, $ad->model]) . "</h1>";
if ($ad->dealer_internal_id) {
	$html .= "<small data-label='" . JText::_( 'COM_PIXELCMS_INTERNAL_ID' ) . "' class='product__description__internal_id'>$ad->dealer_internal_id</small>";
}
if ($this->params->get('print_btn') && $ad->status === 'active') {
    $html .= "<a class=\"product__description__download\" href=\"http://www.traktorpool.de/search/detail/printpreview/machine_id/$ad->id/nocrawl/1/\" target='_blank' rel=\"noopener noreferrer\"><img src=\"/media/jce/icons/pdf.png\"> Datenblatt</a>";
}

$html .= '<table class="product__description__details">';
$html .= "<tr><td>".JText::_( 'COM_PIXELCMS_MANUFACTURER' )."</td><td>{$ad->manufacturer->value}</td></tr>";
if (isset($ad->condition)) $html .= "<tr><td>".JText::_( 'COM_PIXELCMS_CONDITION' )."</td><td>" . JText::_( trim('COM_PIXELCMS_CONDITION_'.strtoupper($ad->condition->id)) ) . "</td></tr>";
$html .= "<tr><td>".JText::_( 'COM_PIXELCMS_BUILD_YEAR' )."</td><td>{$ad->year}</td></tr>";
if ($ad->workhours && $ad->workhours->show) $html .= "<tr><td>".JText::_( 'COM_PIXELCMS_WORKHOURS' )."</td><td>{$ad->workhours->show}</td></tr>";
if (isset($ad->power)) $html .= "<tr><td>".JText::_( 'COM_PIXELCMS_POWER' )."</td><td>{$ad->power->kW} kW ({$ad->power->PS} PS)</td></tr>";
if (isset($ad->max_speed) && $ad->max_speed->show) $html .= "<tr><td>{$ad->max_speed->name}</td><td>{$ad->max_speed->show}</td></tr>";
if (isset($ad->cylinders) && $ad->max_speed->value) $html .= "<tr><td>{$ad->cylinders->name}</td><td>{$ad->cylinders->value}</td></tr>";
if (isset($ad->transmission) && $ad->transmission->show) $html .= "<tr><td>{$ad->transmission->name}</td><td>{$ad->transmission->show}</td></tr>";
if (isset($ad->tyre_type)) $html .= "<tr><td>".JText::_( 'COM_PIXELCMS_TYRE_TYPE' )."</td><td>{$ad->tyre_type}</td></tr>";
if (isset($ad->rim_diameter) && $ad->rim_diameter->value) $html .= "<tr><td>{$ad->rim_diameter->name}</td><td>{$ad->rim_diameter->show}</td></tr>";
if (isset($ad->available) && $ad->available->value) $html .= "<tr><td>{$ad->available->name}</td><td>{$ad->available->value}</td></tr>";
if (isset($ad->_3_point_hitch) && $ad->_3_point_hitch->show) $html .= "<tr><td>{$ad->_3_point_hitch->name}</td><td>{$ad->_3_point_hitch->show}</td></tr>";

if ($ad->equipment) {
    $html .= "<tr><td>".JText::_( 'COM_PIXELCMS_EQUIPMENT' )."</td><td><ul>";
    foreach ($ad->equipment as $key => $value) {
        $html .= "<li>$value</li>";
    }
    $html .= "</ul></td></tr>";
}
if ((isset($ad->front_wheels->type) && $ad->front_wheels->type)|| (isset($ad->back_wheels->type) && $ad->back_wheels->type)) {
    $html .="<td>".JText::_( 'COM_PIXELCMS_WHEELING' )."</td><td>";
    if ($ad->front_wheels->type) {
        if ($ad->back_wheels->type) {
            $html .= JText::_( 'COM_PIXELCMS_FRONT' ).": {$ad->front_wheels->type}";
            if ($ad->front_wheels->quality) {
                $html .=  " / {$ad->front_wheels->quality}%";
            }
            $html .= "<br>".JText::_( 'COM_PIXELCMS_BACK' ).":  {$ad->back_wheels->type}";
            if ($ad->back_wheels->quality) {
                $html .=  " / {$ad->back_wheels->quality}%";
            }
        } else {
            $html .="{$ad->front_wheels->type}";
            if ($ad->front_wheels->quality) {
                $html .=  " / {$ad->front_wheels->quality}%";
            }
        }
    } else if ($ad->back_wheels->type) {
        $html .= "{$ad->back_wheels->type}";
        if ($ad->back_wheels->quality) {
            $html .=  " / {$ad->back_wheels->quality}%";
        }
    }
    $html .="</td></tr>";
}
$html .= '</table>';

if ($ad->free_text) {
    $html .= "<div class='product__description__free_text'>" . nl2br($ad->free_text) . "</div>";
}

$html .= "<div class=\"product__description__price\">";
if (isset ($ad->price) && isset ($ad->price->values) && $ad->price->values->netto > 0) {
    $formatted_netto = number_format($ad->price->values->netto, 2, ',', '.');
    $formatted_brutto = number_format($ad->price->values->brutto, 2, ',', '.');
    $html .= JText::_( 'COM_PIXELCMS_NETTO' );
    if ($ad->offer) {
        $formatted_old = number_format($ad->price->values->old, 2, ',', '.');
        $html .= " <del>$formatted_old {$ad->price->currency}</del>";
    }
    $html .= " $formatted_netto {$ad->price->currency}";
	if ($ad->vat->value) {
		$html .= "<small>".JText::_( 'COM_PIXELCMS_BRUTTO' )." $formatted_brutto {$ad->price->currency}</small>";
	}
} else {
    $html .= JText::_( 'COM_PIXELCMS_ASK_FOR_PRICE' );
}
$html .= "</div>";


$html .= '</div>';
$html .= '</div>';

$html .= '<span onclick="goBack()" class="back_to_overview ad__button">' . JText::_( 'COM_PIXELCMS_BACK_TO_OVERVIEW' ) . '</span>';

$relatedAds =  $this->relatedAds;

if ($relatedAds) {
    $html .= "<h2>".JText::_( 'COM_PIXELCMS_RELATEDADS' )." {$ad->category->name}</h2>";
    $html .= '<div class="custom ads">';
    foreach (array_slice( $relatedAds, 0, 3) as $key => $ad) {
        $html .= '<div class="ad">';
        if (count($ad->images) > 0) {
            $html .= "<a class=\"ad__image\" href=\"$ad->link\">";
            $html .= "<div href=\"$ad->link\" class=\"ad__image__wrapper\" style=\"background-image:url({$ad->images[0]->href})\"></div>";
        } else {
            $html .= "<a class=\"ad__image ad__image--empty\" href=\"$ad->link\">";
        }

        $priceStyle = $this->params->get('price_style');
        $html .= '<div class="ad__price">';
        if (isset($ad->price->values) && $ad->price->values->netto > 0) {
            if (in_array($priceStyle, [0,1,3,4])) {
                $html .= "<div> ".JText::_(  in_array($priceStyle, [0,1]) ?  'COM_PIXELCMS_NETTO' : 'COM_PIXELCMS_NETTO_SHORT' )." " . number_format($ad->price->values->netto, 2, ',', '.') . " {$ad->price->currency}"  . "</div>";
            }
            if (in_array($priceStyle, [0,2,3,5])) {
                $html .= "<div> ".JText::_(  in_array($priceStyle, [0,2]) ?  'COM_PIXELCMS_BRUTTO' : 'COM_PIXELCMS_BRUTTO_SHORT' )." " . number_format($ad->price->values->brutto, 2, ',', '.') . " {$ad->price->currency}"  . "</div>";
            }
        } else {
            $html .= "<div>".JText::_( 'COM_PIXELCMS_ASK_FOR_PRICE' )."</div>";
        }
        $html .= "</div>";
        $html .= "</a>";

        $html .= "<h3>".implode(' ', [$ad->manufacturer->value, $ad->model])."</h3>";
        if ($ad->year) {
            $html .= "<div>".JText::_('COM_PIXELCMS_BUILD_YEAR').": {$ad->year}</div>";
        }
        if ($ad->power) {
            $html .= "<div>".JText::_('COM_PIXELCMS_POWER').": {$ad->power->kW} kW ({$ad->power->PS} PS)</div>";
        }
        if ($ad->workhours) {
            $html .= "<div>".JText::_('COM_PIXELCMS_WORKHOURS').": {$ad->workhours->show}</div>";
        }

        $html .= "<a class=\"ad__button\" href=\"$ad->link\">".JText::_('COM_PIXELCMS_READ_MORE')."</a>";

        $html .= '</div>';
    }
    $html .= '</div>';
}

$html .= "<div class=\"traktorpool-copyright\">Ein Service von <a target=\"_blank\" href=\"https://www.traktorpool.de/{$this->params->get('tracktorpool_alias')}/\"><img src=\"https://www.traktorpool.de/images/frontend/de/logo.svg\" alt=\"Traktorpool\"></a></div>";

echo $html;
