<?php
/**
 * @package    pixelcms_articles
 *
 * @author     christophf <your@email.com>
 * @copyright  A copyright
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       http://your.url.com
 */

use Joomla\Registry\Registry;

defined('_JEXEC') or die;

require_once 'BaseModel.php';

/**
 * Pixelcms_articles model.
 *
 * @package  pixelcms_articles
 * @since    1.0
 */

class TraktorpoolOption {
    public $id;
    public $name;
    public $unit;
    public $href;
    public $type;
    public $value;
    public $show;
}

class Pixelcms_articlesModelTracktorpool_products  extends BaseModel
{
	protected $module = 'traktorpool';
	protected $api_key;
    protected $articleId;
    protected $customer_id;
    protected $contact_persons;
    protected $password;
    protected $username;
    protected $language;
    protected $url;
    protected $ads;
    protected $params;
    protected $allParams;
    protected $menuId;
    protected $filters = [];

	protected $defaults = [
		'print_btn' => 1,
		'price_style' => 0,
		'speed', 750,
        'disable_title_image' => 0,
	];

    protected $hidden = [
        'tracktorpool_apikey',
        'tracktorpool_customer_id',
        'tracktorpool_username',
        'tracktorpool_password',
        'traktorpool_condition',
        'traktorpool_status',
    ];

    public function __construct(array $config = array())
    {
        $this->input = $jinput = JFactory::getApplication()->input;

        $lang = JFactory::getLanguage();
        $langCode = $lang->getTag();
        $langCodeShort = substr($langCode, 0, 2);

        $this->menuId = $jinput->getInt('Itemid');
        $menu = JFactory::getApplication()->getMenu()->getItem($this->menuId);

        $this->params = [];
        $this->allParams = [];
        foreach ($menu->query as $key => $item) {
            if (!in_array($key, $this->hidden)) {
                $this->params[$key] = $item;
            }
            $this->allParams[$key] = $item;
        }

        $this->api_key = $jinput->get('tracktorpool_apikey', $this->allParams['tracktorpool_apikey']);
        $this->customer_id = $jinput->get('tracktorpool_customer_id', $this->allParams['tracktorpool_customer_id']);
        $this->username = $jinput->get('tracktorpool_username', isset($this->allParams['tracktorpool_username']) ? $this->allParams['tracktorpool_username'] : 'pixel-kraft');
        $this->password = $jinput->get('tracktorpool_password', isset($this->allParams['tracktorpool_password']) ? $this->allParams['tracktorpool_password'] : 'VG9gZ9au');

        //$this->print_btn = $jinput->getInt('print_btn');
        $this->articleId = $jinput->getInt('articleId', null);

        $this->language = $langCode;

	    parent::__construct($config);
	    $this->ads = self::prepareAds();
    }

    private function prepareAds()
    {
        $ads = self::checkCache()->ads;

        $ads = array_values(array_filter($ads, function($ad) {
            return $ad->status === 'active';
        }));

        foreach ($ads as $key => &$ad) {
            $ad->power = null;
            $ad->workhours = null;
            $ad->computer = null;
            $ad->equipment = null;
            $ad->cutting_width = null;
            $ad->front_wheels = (object) [];
            $ad->back_wheels = (object) [];
            $ad->free_text = null;

            $lookup = array_flip(array_column($ad->options, 'id'));

            /** @var TraktorpoolOption $option */
            foreach ($ad->options as $key => $option) {
                if ($option->id === 424) {
                    $ad->power = (object) [
                        'kW' => $option->value,
                        'PS' => round($option->value * 1.36),
                    ];
                } else if ($option->id === 314) {
                    $ad->workhours = $option;
                } else if ($option->id === 52) {
                    $ad->computer = (bool) $option->value;
                    $ad->equipment[] = $option->name;
                } else if ($option->id === 111) {
                    $ad->climate = (bool) $option->value;
                    $ad->equipment[] = $option->name;
                } else if ($option->id === 372) {
                    $ad->cutting_width = $option->value;
                } else if ($option->id === 243) {
                    $ad->front_wheels = (object) [
                        'name' => $option->name,
                        'type' => $option->value,
                        'quality' => (isset($lookup[365])) ? $ad->options[$lookup[365]]->value : null,
                    ];
                } else if ($option->id === 244) {
                    $ad->back_wheels = (object) [
                        'name' => $option->name,
                        'type' => $option->value,
                        'quality' => (isset($lookup[364])) ? $ad->options[$lookup[364]]->value : null,
                    ];
                } else if ($option->id === 386) {
                    $ad->cylinders = $option;
                } else if ($option->id === 284) {
                    $ad->transmission = $option;
                } else if ($option->id === 733) {
                    $ad->_3_point_hitch = $option;
                } else if ($option->id === 353) {
                    $ad->max_speed = $option;
                } else if ($option->id === 455) {
                    $ad->rim_diameter = $option;
                } else if ($option->id === 289) {
                    $ad->tyre_type = $option->show;
                } else if ($option->id === 487) {
                    $ad->available = (object) [
                        'value' => $option->value,
                        'name' => $option->name,
                    ];
                } else if ($option->id === 426) {
                    $ad->free_text = $option->value;

                    if (!$ad->power) {
                        // Try to get Power from Desc
                        preg_match_all('/Leistung:(\d+)/', $option->value, $power);
                        if (isset($power[1][0])) $ad->power = (object) [
                            'value' => $power[1][0],
                            'show' => $power[1][0] . ' kW',
                        ];
                    }

                    if (!$ad->workhours) {
                        // Try to get Hours from Desc
                        preg_match_all('/Betriebsstunden:(\d+)/', $option->value, $workhours);
                        if (isset($workhours[1][0])) $ad->workhours = (object) [
                            'value' => $workhours[1][0],
                            'show' => $workhours[1][0] . ' h',
                        ];
                    }

                    if (!$ad->front_wheels) {
                        // Try to get Wheels from Desc
                        preg_match_all('/Bereifung \(v\):(.*?),/', $option->value, $front_wheels);
                        if (isset($front_wheels[1][0])) $ad->front_wheels = (object) ['type' => $front_wheels[1][0]];
                    }
                    if (!$ad->front_wheels) {
                        preg_match_all('/Bereifung \(h\):(.*?),/', $option->value, $back_wheels);
                        if (isset($back_wheels[1][0])) $ad->back_wheels = (object) ['type' => $back_wheels[1][0]];
                    }

                    // Try to get Wheels condition from Desc
                    if ($ad->front_wheels && (!isset($ad->front_wheels->quality) || !$ad->front_wheels->quality)) {
                        preg_match_all('/Zustand-Bereifung \(v\):(\d+)/', $option->value, $front_wheels);
                        if (isset($front_wheels[1][0])) $ad->front_wheels->quality = $front_wheels[1][0];
                    }
                    if ($ad->back_wheels && (!isset($ad->front_wheels->quality) || !$ad->front_wheels->quality )) {
                        preg_match_all('/Zustand-Bereifung \(h\):(\d+)/', $option->value, $back_wheels);
                        if (isset($back_wheels[1][0])) $ad->back_wheels->quality = $back_wheels[1][0];
                    }
                } else if ( $option->type == 'bool' ) {
                    $ad->equipment[] = $option->name;
                }
            }
            if ($ad->price && $ad->price->value > 0) {
                $ad->price->values = (object) [
                    'netto' => $ad->price_decimal->value,
                    'brutto' => $ad->price_decimal->value * (($ad->vat->value) ? ($ad->vat->value / 100 + 1) : 1.19),
                ];
                if ($ad->price->specialprice === 'true') {
                    $ad->offer = true;
                    $ad->price->values->old = $ad->oldprice_decimal->value;
                } else {
                    $ad->offer = false;
                }
            }
            if ($ad->equipment) {
                asort($ad->equipment);
            }

            $query = http_build_query(array_merge($this->params, [
                'articleId' => $ad->id,
                'Itemid' => $this->menuId,
            ]));
            $ad->link = JRoute::_("index.php?$query");

            if ($ad->manufacturer->id === 0) {
                $ad->manufacturer->value = JText::_( 'COM_PIXELCMS_OTHER' );
            }
        }

        usort($ads, function($b, $a) {
            if ($a->id == $b->id) {
                return 0;
            }
            return ($a->id < $b->id) ? -1 : 1;
        });

        return $ads;
    }

    public function getRelatedAds()
    {
        $ad = $this->getData();
        $relatedAds =  array_values(array_filter($this->ads, function ($relatedAd) use ($ad) {
            return !!($ad->category->id == $relatedAd->category->id && $ad->id != $relatedAd->id);
        }));

        self::fisherYatesShuffle($relatedAds, $ad->id);

        return $relatedAds;
    }

	private function getDefault($var, $default)
	{
		return (isset($var)) ? $var : $default;
    }

    private static function fisherYatesShuffle(&$items, $seed)
    {
        @mt_srand($seed);
        $items = array_values($items);
        for ($i = count($items) - 1; $i > 0; $i--)
        {
            $j = @mt_rand(0, $i);
            $tmp = $items[$i];
            $items[$i] = $items[$j];
            $items[$j] = $tmp;
        }
    }

    public function getParams()
    {
        return $this->params;
    }

    private function prepareFilters()
    {
        $this->filters = [
            'status' => ['all', 'active'][$this->input->getInt('traktorpool_status', 0)],
        ];
        if (($condition = $this->input->get('traktorpool_condition', null)) && $condition !== 'false') {
            $this->filters['condition'] = $condition;
        }

        return implode('.', array_merge(...array_map(function($value) {
            return (is_array($value)) ? $value : [$value];
        }, array_values($this->filters))));
    }

	/**
	 *
	 * @return mixed
	 *
	 * @since version
	 * @throws Exception
	 */
	private function getAds()
    {
        $this->prepareFilters();

    	$ads = $this->cURL("https://connect.traktorpool.com/offerer/$this->customer_id/detail_ads", $this->filters);
    	return $this->fetchAdditionalData($ads);
    }

	private function fetchAdditionalData($ads)
	{
		foreach ($ads->ads as &$ad) {
			$ad->contact_persons = $this->getContactPersons($ad);
		}
		return $ads;
	}

	private function getContactPersons($ad)
	{
		return array_map(function($person) {
			return $this->getContactPerson($person->id);
		}, $ad->contact_persons);
	}

	/**
	 * @param $id
	 *
	 * @return mixed
	 *
	 * @since version
	 * @throws Exception
	 */
	private function getContactPerson($id)
	{
		if (isset($this->contact_persons[$id])) {
			return $this->contact_persons[$id];
		}

		return $this->contact_persons[$id] = $this->cURL("https://connect.traktorpool.com/contact_persons/$id");
	}

    private function checkCache($force = false)
    {
        $cacheKey = $this->language . $this->prepareFilters();
	    $ads = $this->cache->get($cacheKey, $this->module);

	    if (empty($ads) || $force) {
		    $ads = $this->getAds();
		    $this->cache->store( serialize($ads), $cacheKey, $this->module);
	    } else {
		    $ads = unserialize($ads);
	    }

	    return $ads;
    }

    public function revalidateCache()
    {
        $this->ads = $this->checkCache(true);
    }

	/**
	 * @param       $url
	 * @param array $parameters
	 *
	 * @return mixed
	 *
	 * @since version
	 * @throws Exception
	 */
	protected function cURL($url, $parameters = [])
	{
		$parameters = array_merge([
			'api_key'=> $this->api_key,
			'language' => substr($this->language, 0, 2)
		], $parameters);

		$query = http_build_query($parameters);

		echo "<pre style=\"display: none;\">$url?$query</pre>";

		$options = [
			CURLOPT_URL => "$url?$query",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_HEADER         => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 20,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "GET",
			CURLOPT_POSTFIELDS => "",
			CURLOPT_USERPWD        => $this->username . ":" . $this->password,
			CURLOPT_HTTPAUTH       => CURLAUTH_DIGEST,
			CURLOPT_HTTPHEADER => [
				"Accept: application/json",
				'Cache-Control: no-cache',
			],
		];

		$ch = curl_init();
		curl_setopt_array( $ch, $options );

		try {
			$raw_response  = curl_exec( $ch );

			// validate CURL status
			if(curl_errno($ch))
				throw new Exception(curl_error($ch), 500);

			$header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
			$header = substr($raw_response, 0, $header_size);
			$body = substr($raw_response, $header_size);

			$status_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
			if ($status_code != 200) {
				throw new Exception("Response with Status Code [" . $status_code . "].", 500);
			}
		} catch(Exception $ex) {
			if ($ch != null) curl_close($ch);
			throw new Exception($ex);
		}

		if ($ch != null) curl_close($ch);

		return json_decode($body);
	}

    public function getData()
    {
        if ($this->articleId) {
            return array_reduce($this->ads, function ($carry, $article) {
                if ($article->id === $this->articleId) {
                    $carry = $article;
                }
                return $carry;
            });
        }
        return $this->ads;
    }
}
