<?php
/**
 * @package    pixelcms_articles
 *
 * @author     christophf <your@email.com>
 * @copyright  A copyright
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       http://your.url.com
 */


defined('_JEXEC') or die;

require_once 'BaseModel.php';

/**
 * Pixelcms_articles model.
 *
 * @package  pixelcms_articles
 * @since    1.0
 */
class Pixelcms_articlesModelPixelcms_news extends BaseModel
{
    protected $api_endpoint;
    protected $articleId;
    protected $module;
    protected $cms_url;
    protected $alias;
    protected $limit;
    protected $api_version;
    protected $defaults = [
        'cut_images' => 1,
        'disable_title_image' => 0,
        'show_date' => 'before',
    ];

    public function __construct(array $config = array())
    {
        $jinput = JFactory::getApplication()->input;
        $this->input = $jinput;
        $this->limit = $jinput->getInt('limit', null);
        $this->articleId = $jinput->getInt('articleId', null);
        $this->cms_url = JFactory::getApplication()->get('pixel_cms_url');
        $this->api_version = JFactory::getApplication()->get('pixel_cms_version');
        $this->api_endpoint = 'news';
        $this->module = "pixelcms_news";
        parent::__construct($config);
    }

    public function getNews()
    {
        return $this->getCachedData();
    }

    public function getCachedData()
    {
        $cacheKey = "$this->api_endpoint:" . (($this->articleId) ? "id:$this->articleId" : "l:$this->limit");
        $articles = $this->cache->get($cacheKey, $this->module);
        if (empty($articles)) {
            $articles = $this->getPreparedData();
            $this->cache->store($articles, $cacheKey, $this->module);
        }
        return json_decode($articles);
    }

    private function getPreparedData()
    {
        $data = json_decode($this->getData());

        if (is_array($data)) {
            foreach ($data as $index => &$article) {
                foreach ($article->images as &$image) {
                    $image = str_replace('http', 'https', $image);
                }
            }
        } else {
            foreach ($data->images as &$image) {
                $image = str_replace('http', 'https', $image);
            }
        }

        return json_encode($data);
    }

    private function getData()
    {
        $parameters = [];

        if ($this->limit > 0) {
            $parameters['limit'] = $this->limit;
        }

        $url = $this->cms_url . '/api/' . $this->api_version . '/' . "$this->api_endpoint";

        if ($this->articleId) {
            $url .= "/$this->articleId";
        }

        return $this->cURL($url, $parameters);
    }
}
